/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import javolution.util.FastList;

public class ExQuestItemList
extends L2GameServerPacket {
    private static final String _S__FE_C6_EXQUESTITEMLIST = "[S] FE:C6 ExQuestItemList";
    private FastList<L2ItemInstance> _items;
    private PcInventory _inventory;

    public ExQuestItemList(FastList<L2ItemInstance> items, PcInventory inv) {
        this._items = items;
        this._inventory = inv;
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(198);
        this.writeH(this._items.size());
        for (L2ItemInstance item : this._items) {
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeD(item.getLocationSlot());
            this.writeQ(item.getCount());
            this.writeD(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(item.getCustomType2());
            if (item.isAugmented()) {
                this.writeD(item.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(item.getMana());
            this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -9999);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
        if (this._inventory.hasInventoryBlock()) {
            this.writeH(this._inventory.getBlockItems().length);
            this.writeC(this._inventory.getBlockMode());
            for (int i : this._inventory.getBlockItems()) {
                this.writeD(i);
            }
        } else {
            this.writeH(0);
        }
        FastList.recycle(this._items);
    }

    @Override
    public String getType() {
        return _S__FE_C6_EXQUESTITEMLIST;
    }
}

