/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class Attack
extends L2GameServerPacket {
    public static final int HITFLAG_USESS = 16;
    public static final int HITFLAG_CRIT = 32;
    public static final int HITFLAG_SHLD = 64;
    public static final int HITFLAG_MISS = 128;
    private static final String _S__06_ATTACK = "[S] 33 Attack";
    private final int _attackerObjId;
    private final int _targetObjId;
    public final boolean soulshot;
    public final int _ssGrade;
    private final int _x;
    private final int _y;
    private final int _z;
    private final int _tx;
    private final int _ty;
    private final int _tz;
    private Hit[] _hits;

    public Attack(L2Character attacker, L2Object target, boolean useShots, int ssGrade) {
        this._attackerObjId = attacker.getObjectId();
        this._targetObjId = target.getObjectId();
        this.soulshot = useShots;
        this._ssGrade = ssGrade;
        this._x = attacker.getX();
        this._y = attacker.getY();
        this._z = attacker.getZ();
        this._tx = target.getX();
        this._ty = target.getY();
        this._tz = target.getZ();
    }

    public Hit createHit(L2Object target, int damage, boolean miss, boolean crit, byte shld) {
        return new Hit(target, damage, miss, crit, shld);
    }

    public void hit(Hit ... hits) {
        if (this._hits == null) {
            this._hits = hits;
            return;
        }
        Hit[] tmp = new Hit[hits.length + this._hits.length];
        System.arraycopy(this._hits, 0, tmp, 0, this._hits.length);
        System.arraycopy(hits, 0, tmp, this._hits.length, hits.length);
        this._hits = tmp;
    }

    public boolean hasHits() {
        return this._hits != null;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(51);
        this.writeD(this._attackerObjId);
        this.writeD(this._targetObjId);
        this.writeD(this._hits[0]._damage);
        this.writeC(this._hits[0]._flags);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeH(this._hits.length - 1);
        if (this._hits.length > 1) {
            for (Hit hit : this._hits) {
                this.writeD(hit._targetId);
                this.writeD(hit._damage);
                this.writeC(hit._flags);
            }
        }
        this.writeD(this._tx);
        this.writeD(this._ty);
        this.writeD(this._tz);
    }

    @Override
    public String getType() {
        return _S__06_ATTACK;
    }

    public class Hit {
        protected final int _targetId;
        protected final int _damage;
        protected int _flags;

        Hit(L2Object target, int damage, boolean miss, boolean crit, byte shld) {
            this._targetId = target.getObjectId();
            this._damage = damage;
            if (miss) {
                this._flags = 128;
                return;
            }
            if (Attack.this.soulshot) {
                this._flags = 0x10 | Attack.this._ssGrade;
            }
            if (crit) {
                this._flags |= 0x20;
            }
            if (!(shld <= 0 || target instanceof L2PcInstance && ((L2PcInstance)target).isInOlympiadMode())) {
                this._flags |= 0x40;
            }
        }
    }
}

