/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestSurrenderPledgeWar
extends L2GameClientPacket {
    private static final String _C__07_REQUESTSURRENDERPLEDGEWAR = "[C] 07 RequestSurrenderPledgeWar";
    private static Logger _log = Logger.getLogger(RequestSurrenderPledgeWar.class.getName());
    private String _pledgeName;
    private L2Clan _clan;
    private L2PcInstance _activeChar;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        this._activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._activeChar == null) {
            return;
        }
        this._clan = this._activeChar.getClan();
        if (this._clan == null) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            this._activeChar.sendMessage("No such clan.");
            this._activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        _log.info("RequestSurrenderPledgeWar by " + ((L2GameClient)this.getClient()).getActiveChar().getClan().getName() + " with " + this._pledgeName);
        if (!this._clan.isAtWarWith(clan.getClanId())) {
            this._activeChar.sendMessage("You aren't at war with this clan.");
            this._activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_SURRENDERED_TO_THE_S1_CLAN);
        msg.addString(this._pledgeName);
        this._activeChar.sendPacket(msg);
        msg = null;
        this._activeChar.deathPenalty(false, false, false);
        ClanTable.getInstance().deleteclanswars(this._clan.getClanId(), clan.getClanId());
    }

    @Override
    public String getType() {
        return _C__07_REQUESTSURRENDERPLEDGEWAR;
    }
}

