/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExReplySentPost;
import com.l2jserver.gameserver.util.Util;

public final class RequestSentPost
extends L2GameClientPacket {
    private static final String _C__D0_6E_REQUESTSENTPOST = "[C] D0:6E RequestSentPost";
    private int _msgId;

    @Override
    protected void readImpl() {
        this._msgId = this.readD();
    }

    @Override
    public void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || !Config.ALLOW_MAIL) {
            return;
        }
        Message msg = MailManager.getInstance().getMessage(this._msgId);
        if (msg == null) {
            return;
        }
        if (!activeChar.isInsideZone((byte)1) && msg.hasAttachments()) {
            activeChar.sendPacket(SystemMessageId.CANT_USE_MAIL_OUTSIDE_PEACE_ZONE);
            return;
        }
        if (msg.getSenderId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to read not own post!", Config.DEFAULT_PUNISH);
            return;
        }
        if (msg.isDeletedBySender()) {
            return;
        }
        activeChar.sendPacket(new ExReplySentPost(msg));
    }

    @Override
    public String getType() {
        return _C__D0_6E_REQUESTSENTPOST;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

