/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.EnchantGroupsTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestExEnchantSkillUntrain
extends L2GameClientPacket {
    private static final String _C__D0_33_REQUESTEXENCHANTSKILLUNTRAIN = "[C] D0:33 RequestExEnchantSkillUntrain";
    private static final Logger _log = Logger.getLogger(RequestExEnchantSkillUntrain.class.getName());
    private static final Logger _logEnchant = Logger.getLogger("enchant");
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    @Override
    protected void runImpl() {
        SystemMessage sm;
        L2Skill skill;
        if (this._skillId <= 0 || this._skillLvl <= 0) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClassId().level() < 3) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS);
            return;
        }
        if (player.getLevel() < 76) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL);
            return;
        }
        if (!player.isAllowedToEnchantSkills()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT);
            return;
        }
        L2EnchantSkillLearn s = EnchantGroupsTable.getInstance().getSkillEnchantmentBySkillId(this._skillId);
        if (s == null) {
            return;
        }
        if (this._skillLvl % 100 == 0) {
            this._skillLvl = s.getBaseLevel();
        }
        if ((skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLvl)) == null) {
            return;
        }
        int reqItemId = 9625;
        int beforeUntrainSkillLevel = player.getSkillLevel(this._skillId);
        if (beforeUntrainSkillLevel - 1 != this._skillLvl && (beforeUntrainSkillLevel % 100 != 1 || this._skillLvl != s.getBaseLevel())) {
            return;
        }
        L2EnchantSkillGroup.EnchantSkillDetail esd = s.getEnchantSkillDetail(beforeUntrainSkillLevel);
        int requiredSp = esd.getSpCost();
        int requireditems = esd.getAdenaCost();
        L2ItemInstance spb = player.getInventory().getItemByItemId(reqItemId);
        if (Config.ES_SP_BOOK_NEEDED && spb == null) {
            player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
            return;
        }
        if (player.getInventory().getAdena() < (long)requireditems) {
            player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
            return;
        }
        boolean check = true;
        if (Config.ES_SP_BOOK_NEEDED) {
            check &= player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)player, true);
        }
        if (!(check &= player.destroyItemByItemId("Consume", 57, requireditems, player, true))) {
            player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
            return;
        }
        player.getStat().addSp((int)((double)requiredSp * 0.8));
        if (Config.LOG_SKILL_ENCHANTS) {
            LogRecord record = new LogRecord(Level.INFO, "Untrain");
            record.setParameters(new Object[]{player, skill, spb});
            record.setLoggerName("skill");
            _logEnchant.log(record);
        }
        player.addSkill(skill, true);
        player.sendPacket(ExEnchantSkillResult.valueOf(true));
        if (Config.DEBUG) {
            _log.fine("Learned skill ID: " + this._skillId + " Level: " + this._skillLvl + " for " + requiredSp + " SP, " + requireditems + " Adena.");
        }
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        if (this._skillLvl > 100) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.UNTRAIN_SUCCESSFUL_SKILL_S1_ENCHANT_LEVEL_DECREASED_BY_ONE);
            sm.addSkillName(this._skillId);
            player.sendPacket(sm);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.UNTRAIN_SUCCESSFUL_SKILL_S1_ENCHANT_LEVEL_RESETED);
            sm.addSkillName(this._skillId);
            player.sendPacket(sm);
        }
        player.sendSkillList();
        int afterUntrainSkillLevel = player.getSkillLevel(this._skillId);
        player.sendPacket(new ExEnchantSkillInfo(this._skillId, afterUntrainSkillLevel));
        player.sendPacket(new ExEnchantSkillInfoDetail(2, this._skillId, afterUntrainSkillLevel - 1, player));
        player.updateShortCuts(this._skillId, afterUntrainSkillLevel);
    }

    @Override
    public String getType() {
        return _C__D0_33_REQUESTEXENCHANTSKILLUNTRAIN;
    }
}

