/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.type.L2WeaponType;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExMoveToLocationInAirShip;
import com.l2jserver.gameserver.network.serverpackets.StopMoveInVehicle;
import com.l2jserver.gameserver.util.Point3D;

public class MoveToLocationInAirShip
extends L2GameClientPacket {
    private static final String _C__D0_20_MOVETOLOCATIONINAIRSHIP = "[C] D0:20 MoveToLocationInAirShip";
    private int _shipId;
    private int _targetX;
    private int _targetY;
    private int _targetZ;
    private int _originX;
    private int _originY;
    private int _originZ;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._shipId = this.readD();
        this._targetX = this.readD();
        this._targetY = this.readD();
        this._targetZ = this.readD();
        this._originX = this.readD();
        this._originY = this.readD();
        this._originZ = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._targetX == this._originX && this._targetY == this._originY && this._targetZ == this._originZ) {
            activeChar.sendPacket(new StopMoveInVehicle(activeChar, this._shipId));
            return;
        }
        if (activeChar.isAttackingNow() && activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemType() == L2WeaponType.BOW) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isSitting() || activeChar.isMovementDisabled()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!activeChar.isInAirShip()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2AirShipInstance airShip = activeChar.getAirShip();
        if (airShip.getObjectId() != this._shipId) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        activeChar.setInVehiclePosition(new Point3D(this._targetX, this._targetY, this._targetZ));
        activeChar.broadcastPacket(new ExMoveToLocationInAirShip(activeChar));
    }

    @Override
    public String getType() {
        return _C__D0_20_MOVETOLOCATIONINAIRSHIP;
    }
}

