/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.EnterWorld;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mmocore.network.ReceivablePacket;

public abstract class L2GameClientPacket
extends ReceivablePacket<L2GameClient> {
    protected static final Logger _log = Logger.getLogger(L2GameClientPacket.class.getName());

    public boolean read() {
        try {
            this.readImpl();
            return true;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Client: " + ((L2GameClient)this.getClient()).toString() + " - Failed reading: " + this.getType() + " - L2J Server Version: " + Config.SERVER_VERSION + " - DP Revision: " + Config.DATAPACK_VERSION + " ; " + e.getMessage(), e);
            if (e instanceof BufferUnderflowException) {
                ((L2GameClient)this.getClient()).onBufferUnderflow();
            }
            return false;
        }
    }

    protected abstract void readImpl();

    public void run() {
        block4: {
            try {
                L2PcInstance actor;
                this.runImpl();
                if (this.triggersOnActionRequest() && (actor = ((L2GameClient)this.getClient()).getActiveChar()) != null && (actor.isSpawnProtected() || actor.isInvul())) {
                    actor.onActionRequest();
                    if (Config.DEBUG) {
                        _log.info("Spawn protection for player " + actor.getName() + " removed by packet: " + this.getType());
                    }
                }
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "Client: " + ((L2GameClient)this.getClient()).toString() + " - Failed running: " + this.getType() + " - L2J Server Version: " + Config.SERVER_VERSION + " - DP Revision: " + Config.DATAPACK_VERSION + " ; " + t.getMessage(), t);
                if (!(this instanceof EnterWorld)) break block4;
                ((L2GameClient)this.getClient()).closeNow();
            }
        }
    }

    protected abstract void runImpl();

    protected final void sendPacket(L2GameServerPacket gsp) {
        ((L2GameClient)this.getClient()).sendPacket(gsp);
    }

    public abstract String getType();

    protected boolean triggersOnActionRequest() {
        return true;
    }
}

