/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;

public final class AllyDismiss
extends L2GameClientPacket {
    private static final String _C__8F_ALLYDISMISS = "[C] 8F AllyDismiss";
    private String _clanName;

    @Override
    protected void readImpl() {
        this._clanName = this.readS();
    }

    @Override
    protected void runImpl() {
        if (this._clanName == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClan() == null) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
            return;
        }
        L2Clan leaderClan = player.getClan();
        if (leaderClan.getAllyId() == 0) {
            player.sendPacket(SystemMessageId.NO_CURRENT_ALLIANCES);
            return;
        }
        if (!player.isClanLeader() || leaderClan.getClanId() != leaderClan.getAllyId()) {
            player.sendPacket(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._clanName);
        if (clan == null) {
            player.sendPacket(SystemMessageId.CLAN_DOESNT_EXISTS);
            return;
        }
        if (clan.getClanId() == leaderClan.getClanId()) {
            player.sendPacket(SystemMessageId.ALLIANCE_LEADER_CANT_WITHDRAW);
            return;
        }
        if (clan.getAllyId() != leaderClan.getAllyId()) {
            player.sendPacket(SystemMessageId.DIFFERENT_ALLIANCE);
            return;
        }
        long currentTime = System.currentTimeMillis();
        leaderClan.setAllyPenaltyExpiryTime(currentTime + (long)Config.ALT_ACCEPT_CLAN_DAYS_WHEN_DISMISSED * 86400000L, 3);
        leaderClan.updateClanInDB();
        clan.setAllyId(0);
        clan.setAllyName(null);
        clan.changeAllyCrest(0, true);
        clan.setAllyPenaltyExpiryTime(currentTime + (long)Config.ALT_ALLY_JOIN_DAYS_WHEN_DISMISSED * 86400000L, 2);
        clan.updateClanInDB();
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, clan, 3));
        player.sendPacket(SystemMessageId.YOU_HAVE_WITHDRAWN_FROM_ALLIANCE);
    }

    @Override
    public String getType() {
        return _C__8F_ALLYDISMISS;
    }
}

