/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;

public class L2JailZone
extends L2ZoneType {
    public L2JailZone(int id) {
        super(id);
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)8, true);
            character.setInsideZone((byte)12, true);
            if (Config.JAIL_IS_PVP) {
                character.setInsideZone((byte)0, true);
                character.sendPacket(SystemMessageId.ENTERED_COMBAT_ZONE);
            }
            if (Config.JAIL_DISABLE_TRANSACTION) {
                character.setInsideZone((byte)14, true);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)8, false);
            character.setInsideZone((byte)12, false);
            if (Config.JAIL_IS_PVP) {
                character.setInsideZone((byte)0, false);
                character.sendPacket(SystemMessageId.LEFT_COMBAT_ZONE);
            }
            if (((L2PcInstance)character).isInJail()) {
                ThreadPoolManager.getInstance().scheduleGeneral(new BackToJail(character), 2000L);
                character.sendMessage("You cannot cheat your way out of here. You must wait until your jail time is over.");
            }
            if (Config.JAIL_DISABLE_TRANSACTION) {
                character.setInsideZone((byte)14, false);
            }
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    static class BackToJail
    implements Runnable {
        private L2PcInstance _activeChar;

        BackToJail(L2Character character) {
            this._activeChar = (L2PcInstance)character;
        }

        @Override
        public void run() {
            this._activeChar.teleToLocation(-114356, -249645, -2984);
        }
    }
}

