/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class OlympiadGameNormal
extends AbstractOlympiadGame {
    protected int _damageP1 = 0;
    protected int _damageP2 = 0;
    protected Participant _playerOne;
    protected Participant _playerTwo;

    protected OlympiadGameNormal(int id, Participant[] opponents) {
        super(id);
        this._playerOne = opponents[0];
        this._playerTwo = opponents[1];
        this._playerOne.player.setOlympiadGameId(id);
        this._playerTwo.player.setOlympiadGameId(id);
    }

    protected static final Participant[] createListOfParticipants(List<Integer> list) {
        if (list == null || list.isEmpty() || list.size() < 2) {
            return null;
        }
        int playerOneObjectId = 0;
        L2PcInstance playerOne = null;
        L2PcInstance playerTwo = null;
        while (list.size() > 1) {
            playerOneObjectId = list.remove(Rnd.nextInt(list.size()));
            playerOne = L2World.getInstance().getPlayer(playerOneObjectId);
            if (playerOne == null || !playerOne.isOnline()) continue;
            playerTwo = L2World.getInstance().getPlayer(list.remove(Rnd.nextInt(list.size())));
            if (playerTwo == null || !playerTwo.isOnline()) {
                list.add(playerOneObjectId);
                continue;
            }
            Participant[] result = new Participant[]{new Participant(playerOne, 1), new Participant(playerTwo, 2)};
            return result;
        }
        return null;
    }

    @Override
    public final boolean containsParticipant(int playerId) {
        return this._playerOne.objectId == playerId || this._playerTwo.objectId == playerId;
    }

    @Override
    public final void sendOlympiadInfo(L2Character player) {
        player.sendPacket(new ExOlympiadUserInfo(this._playerOne));
        player.sendPacket(new ExOlympiadUserInfo(this._playerTwo));
    }

    @Override
    public final void broadcastOlympiadInfo(L2OlympiadStadiumZone stadium) {
        stadium.broadcastPacket(new ExOlympiadUserInfo(this._playerOne));
        stadium.broadcastPacket(new ExOlympiadUserInfo(this._playerTwo));
    }

    @Override
    protected final void broadcastPacket(L2GameServerPacket packet) {
        this._playerOne.updatePlayer();
        if (this._playerOne.player != null) {
            this._playerOne.player.sendPacket(packet);
        }
        this._playerTwo.updatePlayer();
        if (this._playerTwo.player != null) {
            this._playerTwo.player.sendPacket(packet);
        }
    }

    @Override
    protected final boolean portPlayersToArena(List<Location> spawns) {
        boolean result = true;
        try {
            result &= OlympiadGameNormal.portPlayerToArena(this._playerOne, spawns.get(0), this._stadiumID);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
            return false;
        }
        return result &= OlympiadGameNormal.portPlayerToArena(this._playerTwo, spawns.get(spawns.size() / 2), this._stadiumID);
    }

    @Override
    protected boolean needBuffers() {
        return true;
    }

    @Override
    protected final void removals() {
        if (this._aborted) {
            return;
        }
        OlympiadGameNormal.removals(this._playerOne.player, true);
        OlympiadGameNormal.removals(this._playerTwo.player, true);
    }

    @Override
    protected final boolean makeCompetitionStart() {
        if (!super.makeCompetitionStart()) {
            return false;
        }
        if (this._playerOne.player == null || this._playerTwo.player == null) {
            return false;
        }
        this._playerOne.player.setIsOlympiadStart(true);
        this._playerOne.player.updateEffectIcons();
        this._playerTwo.player.setIsOlympiadStart(true);
        this._playerTwo.player.updateEffectIcons();
        return true;
    }

    @Override
    protected final void cleanEffects() {
        if (this._playerOne.player != null && !this._playerOne.defaulted && !this._playerOne.disconnected && this._playerOne.player.getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.cleanEffects(this._playerOne.player);
        }
        if (this._playerTwo.player != null && !this._playerTwo.defaulted && !this._playerTwo.disconnected && this._playerTwo.player.getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.cleanEffects(this._playerTwo.player);
        }
    }

    @Override
    protected final void portPlayersBack() {
        if (this._playerOne.player != null && !this._playerOne.defaulted && !this._playerOne.disconnected) {
            OlympiadGameNormal.portPlayerBack(this._playerOne.player);
        }
        if (this._playerTwo.player != null && !this._playerTwo.defaulted && !this._playerTwo.disconnected) {
            OlympiadGameNormal.portPlayerBack(this._playerTwo.player);
        }
    }

    @Override
    protected final void playersStatusBack() {
        if (this._playerOne.player != null && !this._playerOne.defaulted && !this._playerOne.disconnected && this._playerOne.player.getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.playerStatusBack(this._playerOne.player);
        }
        if (this._playerTwo.player != null && !this._playerTwo.defaulted && !this._playerTwo.disconnected && this._playerTwo.player.getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.playerStatusBack(this._playerTwo.player);
        }
    }

    @Override
    protected final void clearPlayers() {
        this._playerOne.player = null;
        this._playerOne = null;
        this._playerTwo.player = null;
        this._playerTwo = null;
    }

    @Override
    protected final void handleDisconnect(L2PcInstance player) {
        if (player.getObjectId() == this._playerOne.objectId) {
            this._playerOne.disconnected = true;
        } else if (player.getObjectId() == this._playerTwo.objectId) {
            this._playerTwo.disconnected = true;
        }
    }

    @Override
    protected final boolean checkBattleStatus() {
        if (this._aborted) {
            return false;
        }
        if (this._playerOne.player == null || this._playerOne.disconnected) {
            return false;
        }
        return this._playerTwo.player != null && !this._playerTwo.disconnected;
    }

    @Override
    protected final boolean haveWinner() {
        if (!this.checkBattleStatus()) {
            return true;
        }
        boolean playerOneLost = true;
        try {
            if (this._playerOne.player.getOlympiadGameId() == this._stadiumID) {
                playerOneLost = this._playerOne.player.isDead();
            }
        }
        catch (Exception e) {
            playerOneLost = true;
        }
        boolean playerTwoLost = true;
        try {
            if (this._playerTwo.player.getOlympiadGameId() == this._stadiumID) {
                playerTwoLost = this._playerTwo.player.isDead();
            }
        }
        catch (Exception e) {
            playerTwoLost = true;
        }
        return playerOneLost || playerTwoLost;
    }

    @Override
    protected void validateWinner(L2OlympiadStadiumZone stadium) {
        int playerTwoPoints;
        if (this._aborted) {
            return;
        }
        boolean _pOneCrash = this._playerOne.player == null || this._playerOne.disconnected;
        boolean _pTwoCrash = this._playerTwo.player == null || this._playerTwo.disconnected;
        int playerOnePoints = this._playerOne.stats.getInteger("olympiad_points");
        int pointDiff = Math.min(playerOnePoints, playerTwoPoints = this._playerTwo.stats.getInteger("olympiad_points")) / this.getDivider();
        if (pointDiff <= 0) {
            pointDiff = 1;
        } else if (pointDiff > Config.ALT_OLY_MAX_POINTS) {
            pointDiff = Config.ALT_OLY_MAX_POINTS;
        }
        if (this._playerOne.defaulted || this._playerTwo.defaulted) {
            try {
                LogRecord record;
                int points;
                if (this._playerOne.defaulted) {
                    try {
                        points = Math.min(playerOnePoints / 3, Config.ALT_OLY_MAX_POINTS);
                        this.removePointsFromParticipant(this._playerOne, points);
                        this._playerOne.updateNobleStats();
                        if (Config.ALT_OLY_LOG_FIGHTS) {
                            record = new LogRecord(Level.INFO, this._playerOne.name + " default");
                            record.setParameters(new Object[]{this._playerOne.name, this._playerTwo.name, 0, 0, 0, 0, points, this.getType().toString()});
                            _logResults.log(record);
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                    }
                }
                if (this._playerTwo.defaulted) {
                    try {
                        points = Math.min(playerTwoPoints / 3, Config.ALT_OLY_MAX_POINTS);
                        this.removePointsFromParticipant(this._playerTwo, points);
                        this._playerTwo.updateNobleStats();
                        if (Config.ALT_OLY_LOG_FIGHTS) {
                            record = new LogRecord(Level.INFO, this._playerTwo.name + " default");
                            record.setParameters(new Object[]{this._playerOne.name, this._playerTwo.name, 0, 0, 0, 0, points, this.getType().toString()});
                            _logResults.log(record);
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                    }
                }
                return;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                return;
            }
        }
        if (_pOneCrash || _pTwoCrash) {
            try {
                if (_pTwoCrash && !_pOneCrash) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    sm.addString(this._playerOne.name);
                    stadium.broadcastPacket(sm);
                    this._playerOne.updateStat("competitions_won", 1);
                    this.addPointsToParticipant(this._playerOne, pointDiff);
                    this._playerTwo.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerTwo, pointDiff);
                    OlympiadGameNormal.rewardParticipant(this._playerOne.player, this.getReward());
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, this._playerTwo.name + " crash");
                        record.setParameters(new Object[]{this._playerOne.name, this._playerTwo.name, 0, 0, 0, 0, pointDiff, this.getType().toString()});
                        _logResults.log(record);
                    }
                } else if (_pOneCrash && !_pTwoCrash) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    sm.addString(this._playerTwo.name);
                    stadium.broadcastPacket(sm);
                    this._playerTwo.updateStat("competitions_won", 1);
                    this.addPointsToParticipant(this._playerTwo, pointDiff);
                    this._playerOne.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerOne, pointDiff);
                    OlympiadGameNormal.rewardParticipant(this._playerTwo.player, this.getReward());
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, this._playerOne.name + " crash");
                        record.setParameters(new Object[]{this._playerOne.name, this._playerTwo.name, 0, 0, 0, 0, pointDiff, this.getType().toString()});
                        _logResults.log(record);
                    }
                } else if (_pOneCrash && _pTwoCrash) {
                    stadium.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE));
                    this._playerOne.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerOne, pointDiff);
                    this._playerTwo.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerTwo, pointDiff);
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, "both crash");
                        record.setParameters(new Object[]{this._playerOne.name, this._playerTwo.name, 0, 0, 0, 0, pointDiff, this.getType().toString()});
                        _logResults.log(record);
                    }
                }
                this._playerOne.updateStat("competitions_done", 1);
                this._playerTwo.updateStat("competitions_done", 1);
                this._playerOne.updateStat("competitions_done_week", 1);
                this._playerTwo.updateStat("competitions_done_week", 1);
                this._playerOne.updateStat(this.getWeeklyMatchType(), 1);
                this._playerTwo.updateStat(this.getWeeklyMatchType(), 1);
                this._playerOne.updateNobleStats();
                this._playerTwo.updateNobleStats();
                return;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                return;
            }
        }
        try {
            String winner = "\u5f15\u5206";
            long _fightTime = System.currentTimeMillis() - this._startTime;
            double playerOneHp = 0.0;
            if (this._playerOne.player != null && !this._playerOne.player.isDead() && (playerOneHp = this._playerOne.player.getCurrentHp() + this._playerOne.player.getCurrentCp()) < 0.5) {
                playerOneHp = 0.0;
            }
            double playerTwoHp = 0.0;
            if (this._playerTwo.player != null && !this._playerTwo.player.isDead() && (playerTwoHp = this._playerTwo.player.getCurrentHp() + this._playerTwo.player.getCurrentCp()) < 0.5) {
                playerTwoHp = 0.0;
            }
            this._playerOne.updatePlayer();
            this._playerTwo.updatePlayer();
            if (!(this._playerOne.player != null && this._playerOne.player.isOnline() || this._playerTwo.player != null && this._playerTwo.player.isOnline())) {
                this._playerOne.updateStat("competitions_drawn", 1);
                this._playerTwo.updateStat("competitions_drawn", 1);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE);
                stadium.broadcastPacket(sm);
            } else if (this._playerTwo.player == null || !this._playerTwo.player.isOnline() || playerTwoHp == 0.0 && playerOneHp != 0.0 || this._damageP1 > this._damageP2 && playerTwoHp != 0.0 && playerOneHp != 0.0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                sm.addString(this._playerOne.name);
                stadium.broadcastPacket(sm);
                this._playerOne.updateStat("competitions_won", 1);
                this._playerTwo.updateStat("competitions_lost", 1);
                this.addPointsToParticipant(this._playerOne, pointDiff);
                this.removePointsFromParticipant(this._playerTwo, pointDiff);
                winner = this._playerOne.name + " \u52dd\u5229";
                OlympiadGameNormal.saveResults(this._playerOne, this._playerTwo, 1, this._startTime, _fightTime, this.getType());
                OlympiadGameNormal.rewardParticipant(this._playerOne.player, this.getReward());
            } else if (this._playerOne.player == null || !this._playerOne.player.isOnline() || playerOneHp == 0.0 && playerTwoHp != 0.0 || this._damageP2 > this._damageP1 && playerOneHp != 0.0 && playerTwoHp != 0.0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                sm.addString(this._playerTwo.name);
                stadium.broadcastPacket(sm);
                this._playerTwo.updateStat("competitions_won", 1);
                this._playerOne.updateStat("competitions_lost", 1);
                this.addPointsToParticipant(this._playerTwo, pointDiff);
                this.removePointsFromParticipant(this._playerOne, pointDiff);
                winner = this._playerTwo.name + " \u52dd\u5229";
                OlympiadGameNormal.saveResults(this._playerOne, this._playerTwo, 2, this._startTime, _fightTime, this.getType());
                OlympiadGameNormal.rewardParticipant(this._playerTwo.player, this.getReward());
            } else {
                OlympiadGameNormal.saveResults(this._playerOne, this._playerTwo, 0, this._startTime, _fightTime, this.getType());
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE);
                stadium.broadcastPacket(sm);
                this.removePointsFromParticipant(this._playerOne, Math.min(playerOnePoints / this.getDivider(), Config.ALT_OLY_MAX_POINTS));
                this.removePointsFromParticipant(this._playerTwo, Math.min(playerTwoPoints / this.getDivider(), Config.ALT_OLY_MAX_POINTS));
            }
            this._playerOne.updateStat("competitions_done", 1);
            this._playerTwo.updateStat("competitions_done", 1);
            this._playerOne.updateStat("competitions_done_week", 1);
            this._playerTwo.updateStat("competitions_done_week", 1);
            this._playerOne.updateStat(this.getWeeklyMatchType(), 1);
            this._playerTwo.updateStat(this.getWeeklyMatchType(), 1);
            this._playerOne.updateNobleStats();
            this._playerTwo.updateNobleStats();
            if (Config.ALT_OLY_LOG_FIGHTS) {
                LogRecord record = new LogRecord(Level.INFO, winner);
                record.setParameters(new Object[]{this._playerOne.name, this._playerTwo.name, playerOneHp, playerTwoHp, this._damageP1, this._damageP2, pointDiff, this.getType().toString()});
                _logResults.log(record);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
        }
    }

    @Override
    protected final void addDamage(L2PcInstance player, int damage) {
        if (this._playerOne.player == null || this._playerTwo.player == null) {
            return;
        }
        if (player == this._playerOne.player) {
            this._damageP1 += damage;
        } else if (player == this._playerTwo.player) {
            this._damageP2 += damage;
        }
    }

    @Override
    public final String[] getPlayerNames() {
        return new String[]{this._playerOne.name, this._playerTwo.name};
    }

    @Override
    public boolean checkDefaulted() {
        this._playerOne.updatePlayer();
        this._playerTwo.updatePlayer();
        SystemMessage reason = OlympiadGameNormal.checkDefaulted(this._playerOne.player);
        if (reason != null) {
            this._playerOne.defaulted = true;
            if (this._playerTwo.player != null) {
                this._playerTwo.player.sendPacket(reason);
            }
        }
        if ((reason = OlympiadGameNormal.checkDefaulted(this._playerTwo.player)) != null) {
            this._playerTwo.defaulted = true;
            if (this._playerOne.player != null) {
                this._playerOne.player.sendPacket(reason);
            }
        }
        return this._playerOne.defaulted || this._playerTwo.defaulted;
    }

    @Override
    public final void resetDamage() {
        this._damageP1 = 0;
        this._damageP2 = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void saveResults(Participant one, Participant two, int _winner, long _startTime, long _fightTime, CompetitionType type) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO olympiad_fights (charOneId, charTwoId, charOneClass, charTwoClass, winner, start, time, classed) values(?,?,?,?,?,?,?,?)");
            statement.setInt(1, one.objectId);
            statement.setInt(2, two.objectId);
            statement.setInt(3, one.baseClass);
            statement.setInt(4, two.baseClass);
            statement.setInt(5, _winner);
            statement.setLong(6, _startTime);
            statement.setLong(7, _fightTime);
            statement.setInt(8, type == CompetitionType.CLASSED ? 1 : 0);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.log(Level.SEVERE, "SQL exception while saving olympiad fight.", e);
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }
}

