/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import java.util.List;
import javolution.util.FastList;

public final class OlympiadAnnouncer
implements Runnable {
    private static final int OLY_MANAGER = 31688;
    private List<L2Spawn> _managers = new FastList();
    private int _currentStadium = 0;

    public OlympiadAnnouncer() {
        for (L2Spawn spawn : SpawnTable.getInstance().getSpawnTable()) {
            if (spawn == null || spawn.getNpcid() != 31688) continue;
            this._managers.add(spawn);
        }
    }

    @Override
    public void run() {
        int i = OlympiadGameManager.getInstance().getNumberOfStadiums();
        while (--i >= 0) {
            block8: {
                NpcStringId npcString;
                OlympiadGameTask task;
                if (this._currentStadium >= OlympiadGameManager.getInstance().getNumberOfStadiums()) {
                    this._currentStadium = 0;
                }
                if ((task = OlympiadGameManager.getInstance().getOlympiadTask(this._currentStadium)) == null || task.getGame() == null || !task.needAnnounce()) break block8;
                String arenaId = String.valueOf(task.getGame().getStadiumId() + 1);
                switch (task.getGame().getType()) {
                    case NON_CLASSED: {
                        npcString = NpcStringId.OLYMPIAD_CLASS_FREE_INDIVIDUAL_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
                        break;
                    }
                    case CLASSED: {
                        npcString = NpcStringId.OLYMPIAD_CLASS_INDIVIDUAL_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
                        break;
                    }
                    case TEAMS: {
                        npcString = NpcStringId.OLYMPIAD_CLASS_FREE_TEAM_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                for (L2Spawn spawn : this._managers) {
                    L2Npc manager = spawn.getLastSpawn();
                    if (manager == null) continue;
                    NpcSay packet = new NpcSay(manager.getObjectId(), 1, manager.getNpcId(), npcString);
                    packet.addStringParameter(arenaId);
                    manager.broadcastPacket(packet);
                }
                break;
            }
            ++this._currentStadium;
        }
    }
}

