/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public abstract class ClanHall {
    protected static final Logger _log = Logger.getLogger(ClanHall.class.getName());
    private int _clanHallId;
    private List<L2DoorInstance> _doors;
    private String _name;
    private int _ownerId;
    private String _desc;
    private String _location;
    private L2ClanHallZone _zone;
    protected final int _chRate = 604800000;
    protected boolean _isFree = true;
    private Map<Integer, ClanHallFunction> _functions;
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_ITEM_CREATE = 2;
    public static final int FUNC_RESTORE_HP = 3;
    public static final int FUNC_RESTORE_MP = 4;
    public static final int FUNC_RESTORE_EXP = 5;
    public static final int FUNC_SUPPORT = 6;
    public static final int FUNC_DECO_FRONTPLATEFORM = 7;
    public static final int FUNC_DECO_CURTAINS = 8;

    public ClanHall(StatsSet set) {
        this._clanHallId = set.getInteger("id");
        this._name = set.getString("name");
        this._ownerId = set.getInteger("ownerId");
        if (Config.DEBUG) {
            _log.warning("Init Owner : " + this._ownerId);
        }
        this._desc = set.getString("desc");
        this._location = set.getString("location");
        this._functions = new FastMap();
        if (this._ownerId > 0) {
            L2Clan clan = ClanTable.getInstance().getClan(this._ownerId);
            if (clan != null) {
                clan.setHasHideout(this.getId());
            } else {
                this.free();
            }
        }
    }

    public final int getId() {
        return this._clanHallId;
    }

    public final String getName() {
        return this._name;
    }

    public final int getOwnerId() {
        return this._ownerId;
    }

    public final String getDesc() {
        return this._desc;
    }

    public final String getLocation() {
        return this._location;
    }

    public final String getNameHtm() {
        return "&%" + this._clanHallId + ";";
    }

    public final String getLocNameHtm() {
        return "&^" + this._clanHallId + ";";
    }

    public final List<L2DoorInstance> getDoors() {
        if (this._doors == null) {
            this._doors = new FastList();
        }
        return this._doors;
    }

    public final L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getDoorId() != doorId) continue;
            return door;
        }
        return null;
    }

    public ClanHallFunction getFunction(int type) {
        return this._functions.get(type);
    }

    public void setZone(L2ClanHallZone zone) {
        this._zone = zone;
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getZone().isInsideZone(x, y, z);
    }

    public L2ClanHallZone getZone() {
        return this._zone;
    }

    public void free() {
        this._ownerId = 0;
        this._isFree = true;
        for (Map.Entry<Integer, ClanHallFunction> fc : this._functions.entrySet()) {
            this.removeFunction(fc.getKey());
        }
        this._functions.clear();
        this.updateDb();
    }

    public void setOwner(L2Clan clan) {
        if (this._ownerId > 0 || clan == null) {
            return;
        }
        this._ownerId = clan.getClanId();
        this._isFree = false;
        clan.setHasHideout(this.getId());
        clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
        this.updateDb();
    }

    @Deprecated
    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar != null && activeChar.getClanId() == this.getOwnerId()) {
            this.openCloseDoor(doorId, open);
        }
    }

    public void openCloseDoor(int doorId, boolean open) {
        this.openCloseDoor(this.getDoor(doorId), open);
    }

    public void openCloseDoor(L2DoorInstance door, boolean open) {
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    @Deprecated
    public void openCloseDoors(L2PcInstance activeChar, boolean open) {
        if (activeChar != null && activeChar.getClanId() == this.getOwnerId()) {
            this.openCloseDoors(open);
        }
    }

    public void openCloseDoors(boolean open) {
        for (L2DoorInstance door : this.getDoors()) {
            if (door == null) continue;
            if (open) {
                door.openMe();
                continue;
            }
            door.closeMe();
        }
    }

    public void banishForeigners() {
        this._zone.banishForeigners(this.getOwnerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFunctions() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select * from clanhall_functions where hall_id = ?");
            statement.setInt(1, this.getId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._functions.put(rs.getInt("type"), new ClanHallFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: ClanHall.loadFunctions(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(int functionType) {
        this._functions.remove(functionType);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM clanhall_functions WHERE hall_id=? AND type=?");
            statement.setInt(1, this.getId());
            statement.setInt(2, functionType);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: ClanHall.removeFunctions(int functionType): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (Config.DEBUG) {
            _log.warning("Called ClanHall.updateFunctions(int type, int lvl, int lease, long rate, boolean addNew) Owner : " + this.getOwnerId());
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._functions.put(type, new ClanHallFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - this._functions.get(type).getLease();
            if (Config.DEBUG) {
                _log.warning("Called ClanHall.updateFunctions diffLease : " + diffLease);
            }
            if (diffLease > 0) {
                this._functions.remove(type);
                this._functions.put(type, new ClanHallFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                this._functions.get(type).setLease(lease);
                this._functions.get(type).setLvl(lvl);
                this._functions.get(type).dbSave();
            }
        }
        return true;
    }

    public int getGrade() {
        return 0;
    }

    public long getPaidUntil() {
        return 0L;
    }

    public int getLease() {
        return 0;
    }

    public boolean isSiegableHall() {
        return false;
    }

    public abstract void updateDb();

    public class ClanHallFunction {
        private int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public ClanHallFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (ClanHall.this._isFree) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbSave() {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("REPLACE INTO clanhall_functions (hall_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");
                statement.setInt(1, ClanHall.this.getId());
                statement.setInt(2, this.getType());
                statement.setInt(3, this.getLvl());
                statement.setInt(4, this.getLease());
                statement.setLong(5, this.getRate());
                statement.setLong(6, this.getEndTime());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Exception: ClanHall.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                ClanHallFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (ClanHall.this._isFree) {
                        return;
                    }
                    if (ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().getAdena() >= (long)ClanHallFunction.this._fee || !ClanHallFunction.this._cwh) {
                        int fee = ClanHallFunction.this._fee;
                        if (ClanHallFunction.this.getEndTime() == -1L) {
                            fee = ClanHallFunction.this._tempFee;
                        }
                        ClanHallFunction.this.setEndTime(System.currentTimeMillis() + ClanHallFunction.this.getRate());
                        ClanHallFunction.this.dbSave();
                        if (ClanHallFunction.this._cwh) {
                            ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().destroyItemByItemId("CH_function_fee", 57, fee, null, null);
                            if (Config.DEBUG) {
                                _log.warning("deducted " + fee + " adena from " + ClanHall.this.getName() + " owner's cwh for function id : " + ClanHallFunction.this.getType());
                            }
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), ClanHallFunction.this.getRate());
                    } else {
                        ClanHall.this.removeFunction(ClanHallFunction.this.getType());
                    }
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "", e);
                }
            }
        }
    }
}

