/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2BlockInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangePoints;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameCloseUI;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameEnd;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameExtendedChangePoints;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class BlockCheckerEngine {
    private static final Logger _log = Logger.getLogger(BlockCheckerEngine.class.getName());
    private HandysBlockCheckerManager.ArenaParticipantsHolder _holder;
    private FastMap<L2PcInstance, Integer> _redTeamPoints = new FastMap();
    private FastMap<L2PcInstance, Integer> _blueTeamPoints = new FastMap();
    private int _redPoints = 15;
    private int _bluePoints = 15;
    private int _arena = -1;
    private FastList<L2Spawn> _spawns = new FastList();
    private boolean _isRedWinner;
    private long _startedTime;
    private static final int[][] _arenaCoordinates = new int[][]{{-58368, -62745, -57751, -62131, -58053, -62417}, {-58350, -63853, -57756, -63266, -58053, -63551}, {-57194, -63861, -56580, -63249, -56886, -63551}, {-57200, -62727, -56584, -62115, -56850, -62391}};
    private static final int _zCoord = -2405;
    private FastList<L2ItemInstance> _drops = new FastList();
    private static final byte DEFAULT_ARENA = -1;
    private boolean _isStarted = false;
    private ScheduledFuture<?> _task;
    private boolean _abnormalEnd = false;

    public BlockCheckerEngine(HandysBlockCheckerManager.ArenaParticipantsHolder holder, int arena) {
        this._holder = holder;
        if (arena > -1 && arena < 4) {
            this._arena = arena;
        }
        for (L2PcInstance player : holder.getRedPlayers()) {
            this._redTeamPoints.put((Object)player, (Object)0);
        }
        for (L2PcInstance player : holder.getBluePlayers()) {
            this._blueTeamPoints.put((Object)player, (Object)0);
        }
    }

    public void updatePlayersOnStart(HandysBlockCheckerManager.ArenaParticipantsHolder holder) {
        this._holder = holder;
    }

    public HandysBlockCheckerManager.ArenaParticipantsHolder getHolder() {
        return this._holder;
    }

    public int getArena() {
        return this._arena;
    }

    public long getStarterTime() {
        return this._startedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRedPoints() {
        BlockCheckerEngine blockCheckerEngine = this;
        synchronized (blockCheckerEngine) {
            return this._redPoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBluePoints() {
        BlockCheckerEngine blockCheckerEngine = this;
        synchronized (blockCheckerEngine) {
            return this._bluePoints;
        }
    }

    public int getPlayerPoints(L2PcInstance player, boolean isRed) {
        if (!this._redTeamPoints.containsKey((Object)player) && !this._blueTeamPoints.containsKey((Object)player)) {
            return 0;
        }
        if (isRed) {
            return (Integer)this._redTeamPoints.get((Object)player);
        }
        return (Integer)this._blueTeamPoints.get((Object)player);
    }

    public synchronized void increasePlayerPoints(L2PcInstance player, int team) {
        if (player == null) {
            return;
        }
        if (team == 0) {
            int points = (Integer)this._redTeamPoints.get((Object)player) + 1;
            this._redTeamPoints.put((Object)player, (Object)points);
            ++this._redPoints;
            --this._bluePoints;
        } else {
            int points = (Integer)this._blueTeamPoints.get((Object)player) + 1;
            this._blueTeamPoints.put((Object)player, (Object)points);
            ++this._bluePoints;
            --this._redPoints;
        }
    }

    public void addNewDrop(L2ItemInstance item) {
        if (item != null) {
            this._drops.add((Object)item);
        }
    }

    public boolean isStarted() {
        return this._isStarted;
    }

    private void broadcastRelationChanged(L2PcInstance plr) {
        for (L2PcInstance p : this._holder.getAllPlayers()) {
            p.sendPacket(new RelationChanged(plr, plr.getRelation(p), plr.isAutoAttackable(p)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endEventAbnormally() {
        try {
            BlockCheckerEngine blockCheckerEngine = this;
            synchronized (blockCheckerEngine) {
                this._isStarted = false;
                if (this._task != null) {
                    this._task.cancel(true);
                }
                this._abnormalEnd = true;
                ThreadPoolManager.getInstance().executeTask(new EndEvent());
                if (Config.DEBUG) {
                    _log.config("Handys Block Checker Event at arena " + this._arena + " ended due lack of players!");
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Couldnt end Block Checker event at " + this._arena, e);
        }
    }

    private class EndEvent
    implements Runnable {
        private EndEvent() {
        }

        private void clearMe() {
            HandysBlockCheckerManager.getInstance().clearPaticipantQueueByArenaId(BlockCheckerEngine.this._arena);
            BlockCheckerEngine.this._holder.clearPlayers();
            BlockCheckerEngine.this._blueTeamPoints.clear();
            BlockCheckerEngine.this._redTeamPoints.clear();
            HandysBlockCheckerManager.getInstance().setArenaFree(BlockCheckerEngine.this._arena);
            for (L2Spawn spawn : BlockCheckerEngine.this._spawns) {
                spawn.stopRespawn();
                spawn.getLastSpawn().deleteMe();
                SpawnTable.getInstance().deleteSpawn(spawn, false);
                spawn = null;
            }
            BlockCheckerEngine.this._spawns.clear();
            for (L2ItemInstance item : BlockCheckerEngine.this._drops) {
                if (item == null || !item.isVisible() || item.getOwnerId() != 0) continue;
                item.decayMe();
                L2World.getInstance().removeObject(item);
            }
            BlockCheckerEngine.this._drops.clear();
        }

        private void rewardPlayers() {
            if (BlockCheckerEngine.this._redPoints == BlockCheckerEngine.this._bluePoints) {
                return;
            }
            BlockCheckerEngine.this._isRedWinner = BlockCheckerEngine.this._redPoints > BlockCheckerEngine.this._bluePoints;
            if (BlockCheckerEngine.this._isRedWinner) {
                this.rewardAsWinner(true);
                this.rewardAsLooser(false);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.TEAM_C1_WON);
                msg.addString("Red Team");
                BlockCheckerEngine.this._holder.broadCastPacketToTeam(msg);
            } else if (BlockCheckerEngine.this._bluePoints > BlockCheckerEngine.this._redPoints) {
                this.rewardAsWinner(false);
                this.rewardAsLooser(true);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.TEAM_C1_WON);
                msg.addString("Blue Team");
                BlockCheckerEngine.this._holder.broadCastPacketToTeam(msg);
            } else {
                this.rewardAsLooser(true);
                this.rewardAsLooser(false);
            }
        }

        private void rewardAsWinner(boolean isRed) {
            FastMap tempPoints = isRed ? BlockCheckerEngine.this._redTeamPoints : BlockCheckerEngine.this._blueTeamPoints;
            for (Map.Entry points : tempPoints.entrySet()) {
                if (points.getKey() == null) continue;
                if ((Integer)points.getValue() >= 10) {
                    ((L2PcInstance)points.getKey()).addItem("Block Checker", 13067, 2L, (L2Object)points.getKey(), true);
                    continue;
                }
                tempPoints.remove(points.getKey());
            }
            int first = 0;
            int second = 0;
            L2PcInstance winner1 = null;
            L2PcInstance winner2 = null;
            for (Map.Entry entry : tempPoints.entrySet()) {
                L2PcInstance pc = (L2PcInstance)entry.getKey();
                int pcPoints = (Integer)entry.getValue();
                if (pcPoints > first) {
                    second = first;
                    winner2 = winner1;
                    first = pcPoints;
                    winner1 = pc;
                    continue;
                }
                if (pcPoints <= second) continue;
                second = pcPoints;
                winner2 = pc;
            }
            if (winner1 != null) {
                winner1.addItem("Block Checker", 13067, 8L, winner1, true);
            }
            if (winner2 != null) {
                winner2.addItem("Block Checker", 13067, 5L, winner2, true);
            }
        }

        private void rewardAsLooser(boolean isRed) {
            FastMap tempPoints = isRed ? BlockCheckerEngine.this._redTeamPoints : BlockCheckerEngine.this._blueTeamPoints;
            for (Map.Entry entry : tempPoints.entrySet()) {
                L2PcInstance player = (L2PcInstance)entry.getKey();
                if (player == null || (Integer)entry.getValue() < 10) continue;
                player.addItem("Block Checker", 13067, 2L, player, true);
            }
        }

        private void setPlayersBack() {
            ExCubeGameEnd end = new ExCubeGameEnd(BlockCheckerEngine.this._isRedWinner);
            for (L2PcInstance player : BlockCheckerEngine.this._holder.getAllPlayers()) {
                long count;
                if (player == null) continue;
                player.stopAllEffects();
                player.setTeam(0);
                player.setBlockCheckerArena((byte)-1);
                PcInventory inv = player.getInventory();
                if (inv.getItemByItemId(13787) != null) {
                    count = inv.getInventoryItemCount(13787, 0);
                    inv.destroyItemByItemId("Handys Block Checker", 13787, count, player, player);
                }
                if (inv.getItemByItemId(13788) != null) {
                    count = inv.getInventoryItemCount(13788, 0);
                    inv.destroyItemByItemId("Handys Block Checker", 13788, count, player, player);
                }
                BlockCheckerEngine.this.broadcastRelationChanged(player);
                player.teleToLocation(-57478 + Rnd.get(-200, 200), -60367 + Rnd.get(-200, 200), -2370);
                player.setInsideZone((byte)0, false);
                player.sendPacket(end);
                player.broadcastUserInfo();
            }
        }

        @Override
        public void run() {
            if (!BlockCheckerEngine.this._abnormalEnd) {
                this.rewardPlayers();
            }
            this.setPlayersBack();
            this.clearMe();
            BlockCheckerEngine.this._isStarted = false;
            BlockCheckerEngine.this._abnormalEnd = false;
        }
    }

    private class CarryingGirlUnspawn
    implements Runnable {
        private L2Spawn _spawn;

        private CarryingGirlUnspawn(L2Spawn spawn) {
            this._spawn = spawn;
        }

        @Override
        public void run() {
            if (this._spawn == null) {
                _log.warning("HBCE: Block Carrying Girl is null");
                return;
            }
            SpawnTable.getInstance().deleteSpawn(this._spawn, false);
            this._spawn.stopRespawn();
            this._spawn.getLastSpawn().deleteMe();
        }
    }

    private class SpawnRound
    implements Runnable {
        int _numOfBoxes;
        int _round;

        SpawnRound(int numberOfBoxes, int round) {
            this._numOfBoxes = numberOfBoxes;
            this._round = round;
        }

        @Override
        public void run() {
            block14: {
                if (!BlockCheckerEngine.this._isStarted) {
                    return;
                }
                switch (this._round) {
                    case 1: {
                        BlockCheckerEngine.this._task = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRound(20, 2), 60000L);
                        break;
                    }
                    case 2: {
                        BlockCheckerEngine.this._task = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRound(14, 3), 60000L);
                        break;
                    }
                    case 3: {
                        BlockCheckerEngine.this._task = ThreadPoolManager.getInstance().scheduleGeneral(new EndEvent(), 180000L);
                    }
                }
                int random = 2;
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(18672);
                try {
                    for (int i = 0; i < this._numOfBoxes; ++i) {
                        L2Spawn spawn = new L2Spawn(template);
                        spawn.setLocx(_arenaCoordinates[BlockCheckerEngine.this._arena][4] + Rnd.get(-400, 400));
                        spawn.setLocy(_arenaCoordinates[BlockCheckerEngine.this._arena][5] + Rnd.get(-400, 400));
                        spawn.setLocz(-2405);
                        spawn.setAmount(1);
                        spawn.setHeading(1);
                        spawn.setRespawnDelay(1);
                        SpawnTable.getInstance().addNewSpawn(spawn, false);
                        spawn.init();
                        L2BlockInstance block = (L2BlockInstance)spawn.getLastSpawn();
                        if (random % 2 == 0) {
                            block.setRed(true);
                        } else {
                            block.setRed(false);
                        }
                        block.disableCoreAI(true);
                        BlockCheckerEngine.this._spawns.add((Object)spawn);
                        random = (byte)(random + 1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this._round == 1 || this._round == 2) {
                    L2NpcTemplate girl = NpcTable.getInstance().getTemplate(18676);
                    try {
                        L2Spawn girlSpawn = new L2Spawn(girl);
                        girlSpawn.setLocx(_arenaCoordinates[BlockCheckerEngine.this._arena][4] + Rnd.get(-400, 400));
                        girlSpawn.setLocy(_arenaCoordinates[BlockCheckerEngine.this._arena][5] + Rnd.get(-400, 400));
                        girlSpawn.setLocz(-2405);
                        girlSpawn.setAmount(1);
                        girlSpawn.setHeading(1);
                        girlSpawn.setRespawnDelay(1);
                        SpawnTable.getInstance().addNewSpawn(girlSpawn, false);
                        girlSpawn.init();
                        ThreadPoolManager.getInstance().scheduleGeneral(new CarryingGirlUnspawn(girlSpawn), 9000L);
                    }
                    catch (Exception e) {
                        _log.warning("Couldnt Spawn Block Checker NPCs! Wrong instance type at npc table?");
                        if (!Config.DEBUG) break block14;
                        e.printStackTrace();
                    }
                }
            }
            BlockCheckerEngine.this._redPoints += this._numOfBoxes / 2;
            BlockCheckerEngine.this._bluePoints += this._numOfBoxes / 2;
            int timeLeft = (int)((BlockCheckerEngine.this.getStarterTime() - System.currentTimeMillis()) / 1000L);
            ExCubeGameChangePoints changePoints = new ExCubeGameChangePoints(timeLeft, BlockCheckerEngine.this.getBluePoints(), BlockCheckerEngine.this.getRedPoints());
            BlockCheckerEngine.this.getHolder().broadCastPacketToTeam(changePoints);
        }
    }

    public class StartEvent
    implements Runnable {
        private L2Skill _freeze;
        private L2Skill _transformationRed;
        private L2Skill _transformationBlue;
        private final ExCubeGameCloseUI _closeUserInterface = new ExCubeGameCloseUI();

        public StartEvent() {
            this._freeze = SkillTable.getInstance().getInfo(6034, 1);
            this._transformationRed = SkillTable.getInstance().getInfo(6035, 1);
            this._transformationBlue = SkillTable.getInstance().getInfo(6036, 1);
        }

        private void setUpPlayers() {
            HandysBlockCheckerManager.getInstance().setArenaBeingUsed(BlockCheckerEngine.this._arena);
            BlockCheckerEngine.this._redPoints = BlockCheckerEngine.this._spawns.size() / 2;
            BlockCheckerEngine.this._bluePoints = BlockCheckerEngine.this._spawns.size() / 2;
            ExCubeGameChangePoints initialPoints = new ExCubeGameChangePoints(300, BlockCheckerEngine.this._bluePoints, BlockCheckerEngine.this._redPoints);
            for (L2PcInstance player : BlockCheckerEngine.this._holder.getAllPlayers()) {
                if (player == null) continue;
                boolean isRed = BlockCheckerEngine.this._holder.getRedPlayers().contains(player);
                ExCubeGameExtendedChangePoints clientSetUp = new ExCubeGameExtendedChangePoints(300, BlockCheckerEngine.this._bluePoints, BlockCheckerEngine.this._redPoints, isRed, player, 0);
                player.sendPacket(clientSetUp);
                player.sendPacket(ActionFailed.STATIC_PACKET);
                int tc = BlockCheckerEngine.this._holder.getPlayerTeam(player) * 2;
                int x = _arenaCoordinates[BlockCheckerEngine.this._arena][tc];
                int y = _arenaCoordinates[BlockCheckerEngine.this._arena][tc + 1];
                player.teleToLocation(x, y, -2405);
                if (isRed) {
                    BlockCheckerEngine.this._redTeamPoints.put((Object)player, (Object)0);
                    player.setTeam(2);
                } else {
                    BlockCheckerEngine.this._blueTeamPoints.put((Object)player, (Object)0);
                    player.setTeam(1);
                }
                player.stopAllEffects();
                if (player.getPet() != null) {
                    player.getPet().unSummon(player);
                }
                this._freeze.getEffects(player, player);
                if (BlockCheckerEngine.this._holder.getPlayerTeam(player) == 0) {
                    this._transformationRed.getEffects(player, player);
                } else {
                    this._transformationBlue.getEffects(player, player);
                }
                player.setBlockCheckerArena((byte)BlockCheckerEngine.this._arena);
                player.setInsideZone((byte)0, true);
                player.sendPacket(initialPoints);
                player.sendPacket(this._closeUserInterface);
                ExBasicActionList actionList = ExBasicActionList.getStaticPacket(player);
                player.sendPacket(actionList);
                BlockCheckerEngine.this.broadcastRelationChanged(player);
            }
        }

        @Override
        public void run() {
            if (BlockCheckerEngine.this._arena == -1) {
                _log.severe("Couldnt set up the arena Id for the Block Checker event, cancelling event...");
                return;
            }
            BlockCheckerEngine.this._isStarted = true;
            ThreadPoolManager.getInstance().executeTask(new SpawnRound(16, 1));
            this.setUpPlayers();
            BlockCheckerEngine.this._startedTime = System.currentTimeMillis() + 300000L;
        }
    }
}

