/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.position;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.util.Point3D;
import java.util.logging.Logger;

public class ObjectPosition {
    private static final Logger _log = Logger.getLogger(ObjectPosition.class.getName());
    private L2Object _activeObject;
    private int _heading = 0;
    private Point3D _worldPosition;
    private L2WorldRegion _worldRegion;

    public ObjectPosition(L2Object activeObject) {
        this._activeObject = activeObject;
        this.setWorldRegion(L2World.getInstance().getRegion(this.getWorldPosition()));
    }

    public final void setXYZ(int x, int y, int z) {
        assert (this.getWorldRegion() != null);
        this.setWorldPosition(x, y, z);
        try {
            if (L2World.getInstance().getRegion(this.getWorldPosition()) != this.getWorldRegion()) {
                this.updateWorldRegion();
            }
        }
        catch (Exception e) {
            _log.warning("Object Id at bad coords: (x: " + this.getX() + ", y: " + this.getY() + ", z: " + this.getZ() + ").");
            this.badCoords();
        }
    }

    protected void badCoords() {
    }

    public final void setXYZInvisible(int x, int y, int z) {
        assert (this.getWorldRegion() == null);
        if (x > L2World.MAP_MAX_X) {
            x = L2World.MAP_MAX_X - 5000;
        }
        if (x < L2World.MAP_MIN_X) {
            x = L2World.MAP_MIN_X + 5000;
        }
        if (y > L2World.MAP_MAX_Y) {
            y = L2World.MAP_MAX_Y - 5000;
        }
        if (y < L2World.MAP_MIN_Y) {
            y = L2World.MAP_MIN_Y + 5000;
        }
        this.setWorldPosition(x, y, z);
        this.getActiveObject().setIsVisible(false);
    }

    public void updateWorldRegion() {
        if (!this.getActiveObject().isVisible()) {
            return;
        }
        L2WorldRegion newRegion = L2World.getInstance().getRegion(this.getWorldPosition());
        if (newRegion != this.getWorldRegion()) {
            this.getWorldRegion().removeVisibleObject(this.getActiveObject());
            this.setWorldRegion(newRegion);
            this.getWorldRegion().addVisibleObject(this.getActiveObject());
        }
    }

    public L2Object getActiveObject() {
        return this._activeObject;
    }

    public final int getHeading() {
        return this._heading;
    }

    public final void setHeading(int value) {
        this._heading = value;
    }

    public final int getX() {
        return this.getWorldPosition().getX();
    }

    public final void setX(int value) {
        this.getWorldPosition().setX(value);
    }

    public final int getY() {
        return this.getWorldPosition().getY();
    }

    public final void setY(int value) {
        this.getWorldPosition().setY(value);
    }

    public final int getZ() {
        return this.getWorldPosition().getZ();
    }

    public final void setZ(int value) {
        this.getWorldPosition().setZ(value);
    }

    public final Point3D getWorldPosition() {
        if (this._worldPosition == null) {
            this._worldPosition = new Point3D(0, 0, 0);
        }
        return this._worldPosition;
    }

    public final void setWorldPosition(int x, int y, int z) {
        this.getWorldPosition().setXYZ(x, y, z);
    }

    public final void setWorldPosition(Point3D newPosition) {
        this.setWorldPosition(newPosition.getX(), newPosition.getY(), newPosition.getZ());
    }

    public final L2WorldRegion getWorldRegion() {
        return this._worldRegion;
    }

    public void setWorldRegion(L2WorldRegion value) {
        if (this._worldRegion != null && this.getActiveObject() instanceof L2Character) {
            if (value != null) {
                this._worldRegion.revalidateZones((L2Character)this.getActiveObject());
            } else {
                this._worldRegion.removeFromZones((L2Character)this.getActiveObject());
            }
        }
        this._worldRegion = value;
    }
}

