/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2CabaleBufferInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalGuideInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.CharKnownList;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

public class NpcKnownList
extends CharKnownList {
    private ScheduledFuture<?> _trackingTask = null;

    public NpcKnownList(L2Npc activeChar) {
        super(activeChar);
    }

    @Override
    public L2Npc getActiveChar() {
        return (L2Npc)super.getActiveChar();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        return 2 * this.getDistanceToWatchObject(object);
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2FestivalGuideInstance) {
            return 4000;
        }
        if (object instanceof L2NpcInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2CabaleBufferInstance) {
            return 900;
        }
        if (object instanceof L2Playable) {
            return 1500;
        }
        return 500;
    }

    public void startTrackingTask() {
        if (this._trackingTask == null && this.getActiveChar().getAggroRange() > 0) {
            this._trackingTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new TrackingTask(), 2000L, 2000L);
        }
    }

    public void stopTrackingTask() {
        if (this._trackingTask != null) {
            this._trackingTask.cancel(true);
            this._trackingTask = null;
        }
    }

    private class TrackingTask
    implements Runnable {
        @Override
        public void run() {
            Collection<L2PcInstance> players;
            L2Attackable monster;
            if (NpcKnownList.this.getActiveChar() instanceof L2Attackable && (monster = (L2Attackable)NpcKnownList.this.getActiveChar()).getAI().getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO && (players = NpcKnownList.this.getKnownPlayers().values()) != null) {
                for (L2PcInstance pl : players) {
                    if (!pl.isInsideRadius(monster, monster.getAggroRange(), true, false) || pl.isDead() || pl.isInvul()) continue;
                    WalkingManager.getInstance().stopMoving(NpcKnownList.this.getActiveChar(), false);
                    monster.addDamageHate(pl, 0, 100);
                    monster.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, pl, null);
                    break;
                }
            }
        }
    }
}

