/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Couple;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2WeddingManagerInstance
extends L2Npc {
    public L2WeddingManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2WeddingManagerInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = "data/html/mods/Wedding_start.htm";
        String replace = String.valueOf(Config.L2JMOD_WEDDING_PRICE);
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%replace%", replace);
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        String filename = "data/html/mods/Wedding_start.htm";
        String replace = "";
        if (player.getPartnerId() == 0) {
            filename = "data/html/mods/Wedding_nopartner.htm";
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        L2PcInstance ptarget = L2World.getInstance().getPlayer(player.getPartnerId());
        if (ptarget == null || !ptarget.isOnline()) {
            filename = "data/html/mods/Wedding_notfound.htm";
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        if (player.isMarried()) {
            filename = "data/html/mods/Wedding_already.htm";
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        if (player.isMarryAccepted()) {
            filename = "data/html/mods/Wedding_waitforpartner.htm";
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        if (command.startsWith("AcceptWedding")) {
            if (!this.wearsFormalWear(player, ptarget)) {
                filename = "data/html/mods/Wedding_noformal.htm";
                this.sendHtmlMessage(ptarget, filename, replace);
                this.sendHtmlMessage(player, filename, replace);
                return;
            }
            if (player.getAdena() < (long)Config.L2JMOD_WEDDING_PRICE || ptarget.getAdena() < (long)Config.L2JMOD_WEDDING_PRICE) {
                filename = "data/html/mods/Wedding_adena.htm";
                replace = String.valueOf(Config.L2JMOD_WEDDING_PRICE);
                this.sendHtmlMessage(ptarget, filename, replace);
                this.sendHtmlMessage(player, filename, replace);
                return;
            }
            player.reduceAdena("Wedding", Config.L2JMOD_WEDDING_PRICE, player.getLastFolkNPC(), true);
            ptarget.reduceAdena("Wedding", Config.L2JMOD_WEDDING_PRICE, player.getLastFolkNPC(), true);
            player.setMarryAccepted(true);
            Couple couple = CoupleManager.getInstance().getCouple(player.getCoupleId());
            couple.marry();
            player.sendMessage("\u3054\u7d50\u5a5a\u304a\u3081\u3067\u3068\u3046\u3054\u3056\u3044\u307e\u3059\uff01");
            player.setMarried(true);
            player.setMarryRequest(false);
            ptarget.sendMessage("\u3054\u7d50\u5a5a\u304a\u3081\u3067\u3068\u3046\u3054\u3056\u3044\u307e\u3059\uff01");
            ptarget.setMarried(true);
            ptarget.setMarryRequest(false);
            MagicSkillUse MSU = new MagicSkillUse(player, player, 2230, 1, 1, 0);
            player.broadcastPacket(MSU);
            MSU = new MagicSkillUse(ptarget, ptarget, 2230, 1, 1, 0);
            ptarget.broadcastPacket(MSU);
            L2Skill skill = SkillTable.FrequentSkill.LARGE_FIREWORK.getSkill();
            if (skill != null) {
                MSU = new MagicSkillUse(player, player, 2025, 1, 1, 0);
                player.sendPacket(MSU);
                player.broadcastPacket(MSU);
                player.useMagic(skill, false, false);
                MSU = new MagicSkillUse(ptarget, ptarget, 2025, 1, 1, 0);
                ptarget.sendPacket(MSU);
                ptarget.broadcastPacket(MSU);
                ptarget.useMagic(skill, false, false);
            }
            Announcements.getInstance().announceToAll(player.getName() + "\u3055\u3093\u3001" + ptarget.getName() + "\u3055\u3093\u3001\u5fa1\u7d50\u5a5a\u304a\u3081\u3067\u3068\u3046\u3054\u3056\u3044\u307e\u3059\uff01");
            filename = "data/html/mods/Wedding_accepted.htm";
            this.sendHtmlMessage(ptarget, filename, replace);
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        if (command.startsWith("DeclineWedding")) {
            player.setMarryRequest(false);
            ptarget.setMarryRequest(false);
            player.setMarryAccepted(false);
            ptarget.setMarryAccepted(false);
            player.sendMessage("\u7d50\u5a5a\u306e\u7533\u3057\u8fbc\u307f\u3092\u8f9e\u9000\u3057\u307e\u3057\u305f\u3002");
            ptarget.sendMessage("\u30d1\u30fc\u30c8\u30ca\u30fc\u306f\u7d50\u5a5a\u306e\u7533\u3057\u8fbc\u307f\u3092\u3054\u8f9e\u9000\u306a\u3055\u3044\u307e\u3057\u305f\u3002");
            filename = "data/html/mods/Wedding_declined.htm";
            this.sendHtmlMessage(ptarget, filename, replace);
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        if (player.isMarryRequest()) {
            if (!this.wearsFormalWear(player, ptarget)) {
                filename = "data/html/mods/Wedding_noformal.htm";
                this.sendHtmlMessage(ptarget, filename, replace);
                this.sendHtmlMessage(player, filename, replace);
                return;
            }
            filename = "data/html/mods/Wedding_ask.htm";
            player.setMarryRequest(false);
            ptarget.setMarryRequest(false);
            replace = ptarget.getName();
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        if (command.startsWith("AskWedding")) {
            if (!this.wearsFormalWear(player, ptarget)) {
                filename = "data/html/mods/Wedding_noformal.htm";
                this.sendHtmlMessage(ptarget, filename, replace);
                this.sendHtmlMessage(player, filename, replace);
                return;
            }
            player.setMarryAccepted(true);
            ptarget.setMarryRequest(true);
            filename = "data/html/mods/Wedding_ask.htm";
            replace = player.getName();
            this.sendHtmlMessage(ptarget, filename, replace);
            filename = "data/html/mods/Wedding_requested.htm";
            replace = ptarget.getName();
            this.sendHtmlMessage(player, filename, replace);
            return;
        }
        this.sendHtmlMessage(player, filename, replace);
    }

    private boolean wearsFormalWear(L2PcInstance p1, L2PcInstance p2) {
        if (Config.L2JMOD_WEDDING_FORMALWEAR) {
            L2ItemInstance fw1 = p1.getChestArmorInstance();
            L2ItemInstance fw2 = p2.getChestArmorInstance();
            if (fw1 == null || fw2 == null || fw1.getItemId() != 6408 || fw2.getItemId() != 6408) {
                return false;
            }
        }
        return true;
    }

    private void sendHtmlMessage(L2PcInstance player, String filename, String replace) {
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%replace%", replace);
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }
}

