/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

public class L2TotemInstance
extends L2Npc {
    private ScheduledFuture<?> _aiTask;
    private L2Skill _skill;

    public L2TotemInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TotemInstance);
    }

    public void startAITask(int skillId) {
        this._skill = SkillTable.getInstance().getInfo(skillId, 1);
        if (this._aiTask == null) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new TotemAI(this), 3000L, 3000L);
        }
    }

    @Override
    public void deleteMe() {
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
        }
        this._aiTask = null;
        super.deleteMe();
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        return 900;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private class TotemAI
    implements Runnable {
        private final L2TotemInstance _caster;

        protected TotemAI(L2TotemInstance caster) {
            this._caster = caster;
        }

        @Override
        public void run() {
            if (L2TotemInstance.this._skill == null) {
                this._caster._aiTask.cancel(false);
                this._caster._aiTask = null;
                return;
            }
            Collection<L2PcInstance> plrs = L2TotemInstance.this.getKnownList().getKnownPlayersInRadius(L2TotemInstance.this._skill.getSkillRadius());
            for (L2PcInstance player : plrs) {
                if (player.getFirstEffect(L2TotemInstance.this._skill.getId()) != null) continue;
                L2TotemInstance.this._skill.getEffects(player, player);
            }
        }
    }
}

