/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.status.FolkStatus;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.StringUtil;
import java.util.List;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2NpcInstance
extends L2Npc {
    public L2NpcInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2NpcInstance);
        this.setIsInvul(false);
    }

    @Override
    public FolkStatus getStatus() {
        return (FolkStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new FolkStatus(this));
    }

    @Override
    public void addEffect(L2Effect newEffect) {
        if (newEffect != null) {
            if (newEffect.isBuffEffect() || newEffect.isDebuffEffect()) {
                super.addEffect(newEffect);
            } else {
                newEffect.stopEffectTask();
            }
        }
    }

    public List<ClassId> getClassesToTeach() {
        return this.getTemplate().getTeachInfo();
    }

    public static void showSkillList(L2PcInstance player, L2Npc npc, ClassId classId) {
        int npcId;
        if (Config.DEBUG) {
            _log.fine("SkillList activated on: " + npc.getObjectId());
        }
        if ((npcId = npc.getTemplate().getNpcId()) == 32611) {
            FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableCollectSkills(player);
            AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Collect);
            int counts = 0;
            for (L2SkillLearn s : skills) {
                L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                if (sk == null) continue;
                ++counts;
                asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), 0, 1);
            }
            if (counts == 0) {
                int minLevel = SkillTreesData.getInstance().getMinLevelForNewSkill(player, SkillTreesData.getInstance().getCollectSkillTree());
                if (minLevel > 0) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1);
                    sm.addNumber(minLevel);
                    player.sendPacket(sm);
                } else {
                    player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
                }
            } else {
                player.sendPacket(asl);
            }
            return;
        }
        if (!npc.getTemplate().canTeach(classId)) {
            npc.showNoTeachHtml(player);
            return;
        }
        if (((L2NpcInstance)npc).getClassesToTeach().isEmpty()) {
            NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
            String sb = StringUtil.concat("<html><body>I cannot teach you. My class list is empty.<br> Ask admin to fix it. Need add my npcid and classes to skill_learn.sql.<br>NpcId:", String.valueOf(npcId), ", Your classId:", String.valueOf(player.getClassId().getId()), "<br></body></html>");
            html.setHtml(sb);
            player.sendPacket(html);
            return;
        }
        FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableSkills(player, classId, false, false);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.ClassTransform);
        int count = 0;
        player.setLearningClass(classId);
        for (L2SkillLearn s : skills) {
            if (SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel()) == null) continue;
            asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), s.getCalculatedLevelUpSp(player.getClassId(), classId), 0);
            ++count;
        }
        if (count == 0) {
            FastMap<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(classId);
            int minLevel = SkillTreesData.getInstance().getMinLevelForNewSkill(player, skillTree);
            if (minLevel > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1);
                sm.addNumber(minLevel);
                player.sendPacket(sm);
            } else if (player.getClassId().level() == 1) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.NO_SKILLS_TO_LEARN_RETURN_AFTER_S1_CLASS_CHANGE);
                sm.addNumber(2);
                player.sendPacket(sm);
            } else {
                player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
            }
        } else {
            player.sendPacket(asl);
        }
    }
}

