/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.Rnd;
import java.util.concurrent.ScheduledFuture;

public class L2KotatsuInstance
extends L2Npc
implements Runnable {
    private static final int MIN_NPC_ANIMATION = 40000;
    private static final int MAX_NPC_ANIMATION = 120000;
    private long _lastSocialBroadcast = 0L;
    private int _minimalSocialInterval = 40000;
    private L2Skill _skill;
    private ScheduledFuture<?> _aiTask;

    @Override
    public void run() {
        if (this.getKnownList().getKnownPlayers().size() > 0) {
            if (this._skill != null) {
                for (L2PcInstance player : this.getKnownList().getKnownPlayersInRadius(this._skill.getSkillRadius())) {
                    if (player.isInvul() || player.isMovementDisabled() || player.getPkKills() > 5 || !(player.getCurrentHp() < (double)player.getMaxHp()) && !(player.getCurrentCp() < (double)player.getMaxCp()) && !(player.getCurrentMp() < (double)player.getMaxMp())) continue;
                    this.handleEffect(player);
                }
            }
            this.randomAnimation(Rnd.get(1, 3));
        }
    }

    private void handleEffect(L2PcInstance player) {
        if (!this.doesStack(player, this._skill)) {
            this._skill.getEffects(player, player);
        }
    }

    private boolean doesStack(L2PcInstance player, L2Skill checkSkill) {
        String stackType = checkSkill.getEffectTemplates()[0].abnormalType;
        for (L2Effect e : player.getAllEffects()) {
            if (!stackType.equals(e.getAbnormalType())) continue;
            return true;
        }
        return false;
    }

    private void randomAnimation(int animationId) {
        long now = System.currentTimeMillis();
        if (now - this._lastSocialBroadcast > (long)this._minimalSocialInterval) {
            this._lastSocialBroadcast = now;
            this._minimalSocialInterval = Rnd.get(40000, 120000);
            this.broadcastPacket(new SocialAction(this, animationId));
        }
    }

    public L2KotatsuInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.setShowSummonAnimation(false);
        if (ZoneManager.getInstance().getZone(this, L2TownZone.class) == null) {
            this._skill = SkillTable.getInstance().getInfo(22118, 1);
            if (this._skill.getSkillType() == L2SkillType.NOTDONE) {
                throw new RuntimeException();
            }
        }
        this._lastSocialBroadcast = System.currentTimeMillis();
        this._aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, 3000L, 3000L);
    }

    @Override
    public void deleteMe() {
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
            this._aiTask = null;
        }
        this._skill = null;
        super.deleteMe();
    }
}

