/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DecoyKnownList;
import com.l2jserver.gameserver.skills.l2skills.L2SkillDecoy;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class L2DecoyInstance
extends L2Decoy {
    private int _totalLifeTime;
    private int _timeRemaining;
    private Future<?> _DecoyLifeTask;
    private Future<?> _HateSpam;

    public L2DecoyInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2Skill skill) {
        super(objectId, template, owner);
        this.setInstanceType(L2Object.InstanceType.L2DecoyInstance);
        this._totalLifeTime = skill != null ? ((L2SkillDecoy)skill).getTotalLifeTime() : 20000;
        this._timeRemaining = this._totalLifeTime;
        int delay = 1000;
        int skilllevel = this.getTemplate().getIdTemplate() - 13070;
        this._DecoyLifeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new DecoyLifetime(this.getOwner(), this), delay, delay);
        this._HateSpam = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new HateSpam(this, SkillTable.getInstance().getInfo(5272, skilllevel)), 2000L, 5000L);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._HateSpam != null) {
            this._HateSpam.cancel(true);
            this._HateSpam = null;
        }
        this._totalLifeTime = 0;
        DecayTaskManager.getInstance().addDecayTask(this);
        return true;
    }

    @Override
    public DecoyKnownList getKnownList() {
        return (DecoyKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DecoyKnownList(this));
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        if (this._DecoyLifeTask != null) {
            this._DecoyLifeTask.cancel(true);
            this._DecoyLifeTask = null;
        }
        if (this._HateSpam != null) {
            this._HateSpam.cancel(true);
            this._HateSpam = null;
        }
        super.unSummon(owner);
    }

    public void decTimeRemaining(int value) {
        this._timeRemaining -= value;
    }

    public int getTimeRemaining() {
        return this._timeRemaining;
    }

    public int getTotalLifeTime() {
        return this._totalLifeTime;
    }

    static class HateSpam
    implements Runnable {
        private L2DecoyInstance _activeChar;
        private L2Skill _skill;

        HateSpam(L2DecoyInstance activeChar, L2Skill Hate) {
            this._activeChar = activeChar;
            this._skill = Hate;
        }

        @Override
        public void run() {
            try {
                this._activeChar.setTarget(this._activeChar);
                this._activeChar.doCast(this._skill);
            }
            catch (Throwable e) {
                L2Character._log.log(Level.SEVERE, "Decoy Error: ", e);
            }
        }
    }

    static class DecoyLifetime
    implements Runnable {
        private L2PcInstance _activeChar;
        private L2DecoyInstance _Decoy;

        DecoyLifetime(L2PcInstance activeChar, L2DecoyInstance Decoy) {
            this._activeChar = activeChar;
            this._Decoy = Decoy;
        }

        @Override
        public void run() {
            try {
                this._Decoy.decTimeRemaining(1000);
                double newTimeRemaining = this._Decoy.getTimeRemaining();
                if (newTimeRemaining < 0.0) {
                    this._Decoy.unSummon(this._activeChar);
                }
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "Decoy Error: ", e);
            }
        }
    }
}

