/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import java.util.Arrays;

public class EnchantItem {
    protected final boolean _isWeapon;
    protected final int _grade;
    protected final int _maxEnchantLevel;
    protected final double _chanceAdd;
    protected final int[] _itemIds;

    public EnchantItem(boolean wep, int type, int level, double chance, int[] items) {
        this._isWeapon = wep;
        this._grade = type;
        this._maxEnchantLevel = level;
        this._chanceAdd = chance;
        this._itemIds = items;
    }

    public final boolean isValid(L2ItemInstance enchantItem) {
        if (enchantItem == null) {
            return false;
        }
        if (enchantItem.isEnchantable() == 0) {
            return false;
        }
        if (!this.isValidItemType(enchantItem.getItem().getType2())) {
            return false;
        }
        if (this._maxEnchantLevel != 0 && enchantItem.getEnchantLevel() >= this._maxEnchantLevel) {
            return false;
        }
        if (this._grade != enchantItem.getItem().getItemGradeSPlus()) {
            return false;
        }
        return (enchantItem.isEnchantable() <= 1 || this._itemIds != null && Arrays.binarySearch(this._itemIds, enchantItem.getItemId()) >= 0) && (this._itemIds == null || Arrays.binarySearch(this._itemIds, enchantItem.getItemId()) >= 0);
    }

    private boolean isValidItemType(int type2) {
        if (type2 == 0) {
            return this._isWeapon;
        }
        if (type2 == 1 || type2 == 2) {
            return !this._isWeapon;
        }
        return false;
    }

    public final double getChanceAdd() {
        return this._chanceAdd;
    }
}

