/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import com.l2jserver.gameserver.model.L2WalkRoute;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.util.Rnd;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WalkingManager {
    private static final Logger _log = Logger.getLogger(WalkingManager.class.getName());
    private static final byte REPEAT_GO_BACK = 0;
    private static final byte REPEAT_GO_FIRST = 1;
    private static final byte REPEAT_TELE_FIRST = 2;
    private static final byte REPEAT_RANDOM = 3;
    private Map<Integer, L2WalkRoute> _routes = new FastMap();
    private Map<Integer, WalkInfo> _activeRoutes = new FastMap();

    public static final WalkingManager getInstance() {
        return SingletonHolder._instance;
    }

    private WalkingManager() {
        this.load();
    }

    private final void load() {
        _log.info("WalkingManager: Loading walking routes...");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/Routes.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse Routes.xml file: " + e.getMessage(), e);
            }
            Node n = doc.getFirstChild();
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!d.getNodeName().equals("route")) continue;
                boolean debug2 = false;
                int routeId = Integer.parseInt(d.getAttributes().getNamedItem("id").getNodeValue());
                boolean repeat = Boolean.parseBoolean(d.getAttributes().getNamedItem("repeat").getNodeValue());
                String repeatStyle = d.getAttributes().getNamedItem("repeatStyle").getNodeValue();
                byte repeatType = repeatStyle.equalsIgnoreCase("back") ? (byte)0 : (repeatStyle.equalsIgnoreCase("cycle") ? (byte)1 : (repeatStyle.equalsIgnoreCase("conveyor") ? (byte)2 : (repeatStyle.equalsIgnoreCase("random") ? (byte)3 : -1)));
                FastList list = new FastList();
                for (Node r = d.getFirstChild(); r != null; r = r.getNextSibling()) {
                    NamedNodeMap attrs;
                    if (r.getNodeName().equals("point")) {
                        attrs = r.getAttributes();
                        int x = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                        int y = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                        int z = Integer.parseInt(attrs.getNamedItem("Z").getNodeValue());
                        int delay = Integer.parseInt(attrs.getNamedItem("delay").getNodeValue());
                        String chatString = null;
                        NpcStringId npcString = null;
                        Node node = attrs.getNamedItem("string");
                        if (node != null) {
                            chatString = node.getNodeValue();
                        } else {
                            node = attrs.getNamedItem("npcString");
                            if (node != null) {
                                npcString = NpcStringId.getNpcStringId(node.getNodeValue());
                                if (npcString == null) {
                                    _log.log(Level.WARNING, "NpcWalkerRoutersTable: Unknown npcstring '" + node.getNodeValue() + ".");
                                    continue;
                                }
                            } else {
                                node = attrs.getNamedItem("npcStringId");
                                if (node != null && (npcString = NpcStringId.getNpcStringId(Integer.parseInt(node.getNodeValue()))) == null) {
                                    _log.log(Level.WARNING, "NpcWalkerRoutersTable: Unknown npcstring '" + node.getNodeValue() + ".");
                                    continue;
                                }
                            }
                        }
                        boolean running = Boolean.parseBoolean(attrs.getNamedItem("run").getNodeValue());
                        list.add(new L2NpcWalkerNode(0, npcString, chatString, x, y, z, delay, running));
                        continue;
                    }
                    if (!r.getNodeName().equals("stat")) continue;
                    attrs = r.getAttributes();
                    String name = attrs.getNamedItem("name").getNodeValue();
                    String val = attrs.getNamedItem("val").getNodeValue();
                    if (!name.equalsIgnoreCase("debug")) continue;
                    debug2 = Boolean.parseBoolean(val);
                }
                L2WalkRoute newRoute = new L2WalkRoute(routeId, (List<L2NpcWalkerNode>)list, repeat, false, repeatType);
                newRoute.setDebug(debug2);
                this._routes.put(routeId, newRoute);
            }
        }
        _log.info("WalkingManager: loaded " + this._routes.size() + " walking routes.");
    }

    public boolean isRegistered(L2Npc npc) {
        return this._activeRoutes.containsKey(npc.getObjectId());
    }

    public void startMoving(final L2Npc npc, final int routeId) {
        if (this._routes.containsKey(routeId) && npc != null && !npc.isDead()) {
            if (!this._activeRoutes.containsKey(npc.getObjectId())) {
                if (npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_ACTIVE || npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                    WalkInfo walk = new WalkInfo(routeId);
                    L2NpcWalkerNode node = walk.getCurrentNode();
                    if (!npc.isInsideRadius(node.getMoveX(), node.getMoveY(), node.getMoveZ(), 3000, true, false)) {
                        return;
                    }
                    npc.setIsRunning(node.getRunning());
                    npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(node.getMoveX(), node.getMoveY(), node.getMoveZ(), 0));
                    walk._walkCheckTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            WalkingManager.this.startMoving(npc, routeId);
                        }
                    }, 60000L, 60000L);
                    npc.getKnownList().startTrackingTask();
                    this._activeRoutes.put(npc.getObjectId(), walk);
                } else {
                    ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                        @Override
                        public void run() {
                            WalkingManager.this.startMoving(npc, routeId);
                        }
                    }, 60000L);
                }
            } else if (npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_ACTIVE || npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                WalkInfo walk = this._activeRoutes.get(npc.getObjectId());
                if (walk._blocked || walk._suspended) {
                    return;
                }
                walk._blocked = true;
                if (walk.getRoute().getRepeatType() == 3 && walk._nodeArrived) {
                    int newNode = walk._currentNode;
                    while (newNode == walk._currentNode) {
                        newNode = Rnd.get(walk.getRoute().getNodesCount());
                    }
                    walk._currentNode = newNode;
                    walk._nodeArrived = false;
                } else if (walk._currentNode == walk.getRoute().getNodesCount()) {
                    if (walk.getRoute().debug()) {
                        Announcements.getInstance().announceToAll("Last node arrived!");
                    }
                    if (!walk.getRoute().repeatWalk()) {
                        this.cancelMoving(npc);
                        return;
                    }
                    switch (walk.getRoute().getRepeatType()) {
                        case 0: {
                            walk._forward = false;
                            walk._currentNode -= 2;
                            break;
                        }
                        case 1: {
                            walk._currentNode = 0;
                            break;
                        }
                        case 2: {
                            npc.teleToLocation(npc.getSpawn().getLocx(), npc.getSpawn().getLocy(), npc.getSpawn().getLocz());
                            walk._currentNode = 0;
                        }
                    }
                } else if (walk._currentNode == -1) {
                    walk._currentNode = 1;
                    walk._forward = true;
                }
                L2NpcWalkerNode node = walk.getCurrentNode();
                npc.setIsRunning(node.getRunning());
                if (walk.getRoute().debug()) {
                    Announcements.getInstance().announceToAll("Continue to node " + Integer.toString(walk._currentNode));
                }
                npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(node.getMoveX(), node.getMoveY(), node.getMoveZ(), 0));
                walk._blocked = false;
            }
        }
    }

    public void cancelMoving(L2Npc npc) {
        if (this._activeRoutes.containsKey(npc.getObjectId())) {
            this._activeRoutes.get(npc.getObjectId())._walkCheckTask.cancel(true);
            this._activeRoutes.remove(npc.getObjectId());
            npc.getKnownList().stopTrackingTask();
        }
    }

    public void resumeMoving(L2Npc npc) {
        if (!this._activeRoutes.containsKey(npc.getObjectId())) {
            return;
        }
        WalkInfo walk = this._activeRoutes.get(npc.getObjectId());
        walk._suspended = false;
        this.startMoving(npc, walk.getRoute().getId());
    }

    public void stopMoving(L2Npc npc, boolean suspend) {
        if (!this._activeRoutes.containsKey(npc.getObjectId())) {
            return;
        }
        WalkInfo walk = this._activeRoutes.get(npc.getObjectId());
        walk._suspended = suspend;
        npc.stopMove(null);
        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
    }

    public void onArrived(L2Npc npc) {
        L2NpcWalkerNode node;
        WalkInfo walk;
        if (this._activeRoutes.containsKey(npc.getObjectId()) && (walk = this._activeRoutes.get(npc.getObjectId()))._currentNode >= 0 && walk._currentNode < walk.getRoute().getNodesCount() && (node = walk.getRoute().getNodeList().get(walk._currentNode)).getMoveX() == npc.getX() && node.getMoveY() == npc.getY()) {
            if (walk.getRoute().debug()) {
                Announcements.getInstance().announceToAll("Arrived to node " + Integer.toString(walk._currentNode));
            }
            walk._nodeArrived = true;
            if (walk.getRoute().getRepeatType() != 3) {
                if (walk._forward) {
                    walk._currentNode++;
                } else {
                    walk._currentNode--;
                }
            }
            int delay = walk._currentNode >= walk.getRoute().getNodesCount() ? walk.getRoute().getLastNode().getDelay() : (walk._currentNode < 0 ? walk.getRoute().getNodeList().get(0).getDelay() : walk.getCurrentNode().getDelay());
            walk._blocked = true;
            ThreadPoolManager.getInstance().scheduleGeneral(new ArrivedTask(npc, walk), 100L + (long)delay * 1000L);
        }
    }

    public void onDeath(L2Npc npc) {
        if (this._activeRoutes.containsKey(npc.getObjectId())) {
            this.cancelMoving(npc);
        }
    }

    private static class SingletonHolder {
        protected static final WalkingManager _instance = new WalkingManager();

        private SingletonHolder() {
        }
    }

    private class ArrivedTask
    implements Runnable {
        WalkInfo _walk;
        L2Npc _npc;

        public ArrivedTask(L2Npc npc, WalkInfo walk) {
            this._npc = npc;
            this._walk = walk;
        }

        @Override
        public void run() {
            this._walk._blocked = false;
            WalkingManager.this.startMoving(this._npc, this._walk.getRoute().getId());
        }
    }

    private class WalkInfo {
        private ScheduledFuture<?> _walkCheckTask;
        private boolean _blocked = false;
        private boolean _suspended = false;
        private boolean _nodeArrived = false;
        private int _currentNode = 0;
        private boolean _forward = true;
        private int _routeId;

        public WalkInfo(int routeId) {
            this._routeId = routeId;
        }

        private L2WalkRoute getRoute() {
            return (L2WalkRoute)WalkingManager.this._routes.get(this._routeId);
        }

        private L2NpcWalkerNode getCurrentNode() {
            return this.getRoute().getNodeList().get(this._currentNode);
        }
    }
}

