/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Siege;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class SiegeManager {
    private static final Logger _log = Logger.getLogger(SiegeManager.class.getName());
    private int _attackerMaxClans = 500;
    private int _attackerRespawnDelay = 0;
    private int _defenderMaxClans = 500;
    private TIntObjectHashMap<FastList<SiegeSpawn>> _artefactSpawnList;
    private TIntObjectHashMap<FastList<SiegeSpawn>> _controlTowerSpawnList;
    private TIntObjectHashMap<FastList<SiegeSpawn>> _flameTowerSpawnList;
    private int _flagMaxCount = 1;
    private int _siegeClanMinLevel = 5;
    private int _siegeLength = 120;
    private int _bloodAllianceReward = 0;

    public static final SiegeManager getInstance() {
        return SingletonHolder._instance;
    }

    private SiegeManager() {
        _log.info("Initializing SiegeManager");
        this.load();
    }

    public final void addSiegeSkills(L2PcInstance character) {
        for (L2Skill sk : SkillTable.getInstance().getSiegeSkills(character.isNoble(), character.getClan().getHasCastle() > 0)) {
            character.addSkill(sk, false);
        }
    }

    public final boolean checkIfOkToSummon(L2Character activeChar, boolean isCheckOnly) {
        if (!(activeChar instanceof L2PcInstance)) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        Castle castle = CastleManager.getInstance().getCastle(player);
        if (castle == null || castle.getCastleId() <= 0) {
            text = "You must be on castle ground to summon this";
        } else if (!castle.getSiege().getIsInProgress()) {
            text = "You can only summon this during a siege.";
        } else if (player.getClanId() != 0 && castle.getSiege().getAttackerClan(player.getClanId()) == null) {
            text = "You can only summon this as a registered attacker.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkIsRegistered(L2Clan clan, int castleid) {
        if (clan == null) {
            return false;
        }
        if (clan.getHasCastle() > 0) {
            return true;
        }
        Connection con = null;
        boolean register = false;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_id FROM siege_clans where clan_id=? and castle_id=?");
            statement.setInt(1, clan.getClanId());
            statement.setInt(2, castleid);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                register = true;
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: checkIsRegistered(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return register;
    }

    public final void removeSiegeSkills(L2PcInstance character) {
        for (L2Skill sk : SkillTable.getInstance().getSiegeSkills(character.isNoble(), character.getClan().getHasCastle() > 0)) {
            character.removeSkill(sk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        InputStream is = null;
        try {
            is = new FileInputStream(new File("./config/siege.properties"));
            Properties siegeSettings = new Properties();
            siegeSettings.load(is);
            this._attackerMaxClans = Integer.decode(siegeSettings.getProperty("AttackerMaxClans", "500"));
            this._attackerRespawnDelay = Integer.decode(siegeSettings.getProperty("AttackerRespawn", "0"));
            this._defenderMaxClans = Integer.decode(siegeSettings.getProperty("DefenderMaxClans", "500"));
            this._flagMaxCount = Integer.decode(siegeSettings.getProperty("MaxFlags", "1"));
            this._siegeClanMinLevel = Integer.decode(siegeSettings.getProperty("SiegeClanMinLevel", "5"));
            this._siegeLength = Integer.decode(siegeSettings.getProperty("SiegeLength", "120"));
            this._bloodAllianceReward = Integer.decode(siegeSettings.getProperty("BloodAllianceReward", "0"));
            this._controlTowerSpawnList = new TIntObjectHashMap();
            this._artefactSpawnList = new TIntObjectHashMap();
            this._flameTowerSpawnList = new TIntObjectHashMap();
            for (Castle castle : CastleManager.getInstance().getCastles()) {
                String _spawnParams;
                String _spawnParams2;
                String _spawnParams3;
                FastList _controlTowersSpawns = new FastList();
                for (int i = 1; i < 255 && !(_spawnParams3 = siegeSettings.getProperty(castle.getName() + "ControlTower" + i, "")).isEmpty(); ++i) {
                    StringTokenizer st = new StringTokenizer(_spawnParams3.trim(), ",");
                    try {
                        int x = Integer.parseInt(st.nextToken());
                        int y = Integer.parseInt(st.nextToken());
                        int z = Integer.parseInt(st.nextToken());
                        int npc_id = Integer.parseInt(st.nextToken());
                        int hp = Integer.parseInt(st.nextToken());
                        _controlTowersSpawns.add((Object)new SiegeSpawn(castle.getCastleId(), x, y, z, 0, npc_id, hp));
                        continue;
                    }
                    catch (Exception e) {
                        _log.warning("Error while loading control tower(s) for " + castle.getName() + " castle.");
                    }
                }
                FastList _flameTowersSpawns = new FastList();
                for (int i = 1; i < 255 && !(_spawnParams2 = siegeSettings.getProperty(castle.getName() + "FlameTower" + i, "")).isEmpty(); ++i) {
                    StringTokenizer st = new StringTokenizer(_spawnParams2.trim(), ",");
                    try {
                        int x = Integer.parseInt(st.nextToken());
                        int y = Integer.parseInt(st.nextToken());
                        int z = Integer.parseInt(st.nextToken());
                        int npc_id = Integer.parseInt(st.nextToken());
                        int hp = Integer.parseInt(st.nextToken());
                        _flameTowersSpawns.add((Object)new SiegeSpawn(castle.getCastleId(), x, y, z, 0, npc_id, hp));
                        continue;
                    }
                    catch (Exception e) {
                        _log.warning("Error while loading artefact(s) for " + castle.getName() + " castle.");
                    }
                }
                FastList _artefactSpawns = new FastList();
                for (int i = 1; i < 255 && !(_spawnParams = siegeSettings.getProperty(castle.getName() + "Artefact" + i, "")).isEmpty(); ++i) {
                    StringTokenizer st = new StringTokenizer(_spawnParams.trim(), ",");
                    try {
                        int x = Integer.parseInt(st.nextToken());
                        int y = Integer.parseInt(st.nextToken());
                        int z = Integer.parseInt(st.nextToken());
                        int heading = Integer.parseInt(st.nextToken());
                        int npc_id = Integer.parseInt(st.nextToken());
                        _artefactSpawns.add((Object)new SiegeSpawn(castle.getCastleId(), x, y, z, heading, npc_id));
                        continue;
                    }
                    catch (Exception e) {
                        _log.warning("Error while loading artefact(s) for " + castle.getName() + " castle.");
                    }
                }
                MercTicketManager.MERCS_MAX_PER_CASTLE[castle.getCastleId() - 1] = Integer.parseInt(siegeSettings.getProperty(castle.getName() + "MaxMercenaries", Integer.toString(MercTicketManager.MERCS_MAX_PER_CASTLE[castle.getCastleId() - 1])).trim());
                this._controlTowerSpawnList.put(castle.getCastleId(), (Object)_controlTowersSpawns);
                this._artefactSpawnList.put(castle.getCastleId(), (Object)_artefactSpawns);
                this._flameTowerSpawnList.put(castle.getCastleId(), (Object)_flameTowersSpawns);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while loading siege data: " + e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public final FastList<SiegeSpawn> getArtefactSpawnList(int _castleId) {
        return (FastList)this._artefactSpawnList.get(_castleId);
    }

    public final FastList<SiegeSpawn> getControlTowerSpawnList(int _castleId) {
        return (FastList)this._controlTowerSpawnList.get(_castleId);
    }

    public final FastList<SiegeSpawn> getFlameTowerSpawnList(int _castleId) {
        return (FastList)this._flameTowerSpawnList.get(_castleId);
    }

    public final int getAttackerMaxClans() {
        return this._attackerMaxClans;
    }

    public final int getAttackerRespawnDelay() {
        return this._attackerRespawnDelay;
    }

    public final int getDefenderMaxClans() {
        return this._defenderMaxClans;
    }

    public final int getFlagMaxCount() {
        return this._flagMaxCount;
    }

    public final Siege getSiege(L2Object activeObject) {
        return this.getSiege(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final Siege getSiege(int x, int y, int z) {
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            if (!castle.getSiege().checkIfInZone(x, y, z)) continue;
            return castle.getSiege();
        }
        return null;
    }

    public final int getSiegeClanMinLevel() {
        return this._siegeClanMinLevel;
    }

    public final int getSiegeLength() {
        return this._siegeLength;
    }

    public final int getBloodAllianceReward() {
        return this._bloodAllianceReward;
    }

    public final List<Siege> getSieges() {
        FastList sieges = new FastList();
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            sieges.add((Object)castle.getSiege());
        }
        return sieges;
    }

    private static class SingletonHolder {
        protected static final SiegeManager _instance = new SiegeManager();

        private SingletonHolder() {
        }
    }

    public static class SiegeSpawn {
        Location _location;
        private int _npcId;
        private int _heading;
        private int _castleId;
        private int _hp;

        public SiegeSpawn(int castle_id, int x, int y, int z, int heading, int npc_id) {
            this._castleId = castle_id;
            this._location = new Location(x, y, z, heading);
            this._heading = heading;
            this._npcId = npc_id;
        }

        public SiegeSpawn(int castle_id, int x, int y, int z, int heading, int npc_id, int hp) {
            this._castleId = castle_id;
            this._location = new Location(x, y, z, heading);
            this._heading = heading;
            this._npcId = npc_id;
            this._hp = hp;
        }

        public int getCastleId() {
            return this._castleId;
        }

        public int getNpcId() {
            return this._npcId;
        }

        public int getHeading() {
            return this._heading;
        }

        public int getHp() {
            return this._hp;
        }

        public Location getLocation() {
            return this._location;
        }
    }
}

