/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.CombatFlag;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class FortSiegeManager {
    private static final Logger _log = Logger.getLogger(FortSiegeManager.class.getName());
    private int _attackerMaxClans = 500;
    private FastMap<Integer, FastList<SiegeSpawn>> _commanderSpawnList;
    private FastMap<Integer, FastList<CombatFlag>> _flagList;
    private int _flagMaxCount = 1;
    private int _siegeClanMinLevel = 4;
    private int _siegeLength = 60;
    private int _countDownLength = 10;
    private int _suspiciousMerchantRespawnDelay = 180;
    private List<FortSiege> _sieges;

    public static final FortSiegeManager getInstance() {
        return SingletonHolder._instance;
    }

    private FortSiegeManager() {
        _log.info("Initializing FortSiegeManager");
        this.load();
    }

    public final void addSiegeSkills(L2PcInstance character) {
        character.addSkill(SkillTable.FrequentSkill.SEAL_OF_RULER.getSkill(), false);
        character.addSkill(SkillTable.FrequentSkill.BUILD_HEADQUARTERS.getSkill(), false);
    }

    public final boolean checkIfOkToSummon(L2Character activeChar, boolean isCheckOnly) {
        if (!(activeChar instanceof L2PcInstance)) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        Fort fort = FortManager.getInstance().getFort(player);
        if (fort == null || fort.getFortId() <= 0) {
            text = "You must be on fort ground to summon this";
        } else if (!fort.getSiege().getIsInProgress()) {
            text = "You can only summon this during a siege.";
        } else if (player.getClanId() != 0 && fort.getSiege().getAttackerClan(player.getClanId()) == null) {
            text = "You can only summon this as a registered attacker.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkIsRegistered(L2Clan clan, int fortid) {
        if (clan == null) {
            return false;
        }
        Connection con = null;
        boolean register = false;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_id FROM fortsiege_clans where clan_id=? and fort_id=?");
            statement.setInt(1, clan.getClanId());
            statement.setInt(2, fortid);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                register = true;
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: checkIsRegistered(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return register;
    }

    public final void removeSiegeSkills(L2PcInstance character) {
        character.removeSkill(SkillTable.FrequentSkill.SEAL_OF_RULER.getSkill());
        character.removeSkill(SkillTable.FrequentSkill.BUILD_HEADQUARTERS.getSkill());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        InputStream is = null;
        try {
            is = new FileInputStream(new File("./config/fortsiege.properties"));
            Properties siegeSettings = new Properties();
            siegeSettings.load(is);
            this._attackerMaxClans = Integer.decode(siegeSettings.getProperty("AttackerMaxClans", "500"));
            this._flagMaxCount = Integer.decode(siegeSettings.getProperty("MaxFlags", "1"));
            this._siegeClanMinLevel = Integer.decode(siegeSettings.getProperty("SiegeClanMinLevel", "4"));
            this._siegeLength = Integer.decode(siegeSettings.getProperty("SiegeLength", "60"));
            this._countDownLength = Integer.decode(siegeSettings.getProperty("CountDownLength", "10"));
            this._suspiciousMerchantRespawnDelay = Integer.decode(siegeSettings.getProperty("SuspiciousMerchantRespawnDelay", "180"));
            this._commanderSpawnList = new FastMap();
            this._flagList = new FastMap();
            for (Fort fort : FortManager.getInstance().getForts()) {
                int z;
                int y;
                StringTokenizer st;
                String _spawnParams;
                int i;
                FastList _commanderSpawns = new FastList();
                FastList _flagSpawns = new FastList();
                for (i = 1; i < 5 && (_spawnParams = siegeSettings.getProperty(fort.getName().replace(" ", "") + "Commander" + i, "")).length() != 0; ++i) {
                    st = new StringTokenizer(_spawnParams.trim(), ",");
                    try {
                        int x = Integer.parseInt(st.nextToken());
                        y = Integer.parseInt(st.nextToken());
                        z = Integer.parseInt(st.nextToken());
                        int heading = Integer.parseInt(st.nextToken());
                        int npc_id = Integer.parseInt(st.nextToken());
                        _commanderSpawns.add((Object)new SiegeSpawn(fort.getFortId(), x, y, z, heading, npc_id, i));
                        continue;
                    }
                    catch (Exception e) {
                        _log.warning("Error while loading commander(s) for " + fort.getName() + " fort.");
                    }
                }
                this._commanderSpawnList.put((Object)fort.getFortId(), (Object)_commanderSpawns);
                for (i = 1; i < 4 && (_spawnParams = siegeSettings.getProperty(fort.getName().replace(" ", "") + "Flag" + i, "")).length() != 0; ++i) {
                    st = new StringTokenizer(_spawnParams.trim(), ",");
                    try {
                        int x = Integer.parseInt(st.nextToken());
                        y = Integer.parseInt(st.nextToken());
                        z = Integer.parseInt(st.nextToken());
                        int flag_id = Integer.parseInt(st.nextToken());
                        _flagSpawns.add((Object)new CombatFlag(fort.getFortId(), x, y, z, 0, flag_id));
                        continue;
                    }
                    catch (Exception e) {
                        _log.warning("Error while loading flag(s) for " + fort.getName() + " fort.");
                    }
                }
                this._flagList.put((Object)fort.getFortId(), (Object)_flagSpawns);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while loading fortsiege data." + e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public final FastList<SiegeSpawn> getCommanderSpawnList(int _fortId) {
        if (this._commanderSpawnList.containsKey((Object)_fortId)) {
            return (FastList)this._commanderSpawnList.get((Object)_fortId);
        }
        return null;
    }

    public final FastList<CombatFlag> getFlagList(int _fortId) {
        if (this._flagList.containsKey((Object)_fortId)) {
            return (FastList)this._flagList.get((Object)_fortId);
        }
        return null;
    }

    public final int getAttackerMaxClans() {
        return this._attackerMaxClans;
    }

    public final int getFlagMaxCount() {
        return this._flagMaxCount;
    }

    public final int getSuspiciousMerchantRespawnDelay() {
        return this._suspiciousMerchantRespawnDelay;
    }

    public final FortSiege getSiege(L2Object activeObject) {
        return this.getSiege(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final FortSiege getSiege(int x, int y, int z) {
        for (Fort fort : FortManager.getInstance().getForts()) {
            if (!fort.getSiege().checkIfInZone(x, y, z)) continue;
            return fort.getSiege();
        }
        return null;
    }

    public final int getSiegeClanMinLevel() {
        return this._siegeClanMinLevel;
    }

    public final int getSiegeLength() {
        return this._siegeLength;
    }

    public final int getCountDownLength() {
        return this._countDownLength;
    }

    public final List<FortSiege> getSieges() {
        if (this._sieges == null) {
            this._sieges = new FastList();
        }
        return this._sieges;
    }

    public final void addSiege(FortSiege fortSiege) {
        if (this._sieges == null) {
            this._sieges = new FastList();
        }
        this._sieges.add(fortSiege);
    }

    public boolean isCombat(int itemId) {
        return itemId == 9819;
    }

    public boolean activateCombatFlag(L2PcInstance player, L2ItemInstance item) {
        if (!this.checkIfCanPickup(player)) {
            return false;
        }
        Fort fort = FortManager.getInstance().getFort(player);
        FastList fcf = (FastList)this._flagList.get((Object)fort.getFortId());
        for (CombatFlag cf : fcf) {
            if (cf.getCombatFlagInstance() != item) continue;
            cf.activate(player, item);
        }
        return true;
    }

    public boolean checkIfCanPickup(L2PcInstance player) {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED);
        sm.addItemName(9819);
        if (player.isCombatFlagEquipped()) {
            player.sendPacket(sm);
            return false;
        }
        Fort fort = FortManager.getInstance().getFort(player);
        if (fort == null || fort.getFortId() <= 0) {
            player.sendPacket(sm);
            return false;
        }
        if (!fort.getSiege().getIsInProgress()) {
            player.sendPacket(sm);
            return false;
        }
        if (fort.getSiege().getAttackerClan(player.getClan()) == null) {
            player.sendPacket(sm);
            return false;
        }
        return true;
    }

    public void dropCombatFlag(L2PcInstance player, int fortId) {
        Fort fort = FortManager.getInstance().getFortById(fortId);
        FastList fcf = (FastList)this._flagList.get((Object)fort.getFortId());
        for (CombatFlag cf : fcf) {
            if (cf.getPlayerObjectId() != player.getObjectId()) continue;
            cf.dropIt();
            if (!fort.getSiege().getIsInProgress()) continue;
            cf.spawnMe();
        }
    }

    private static class SingletonHolder {
        protected static final FortSiegeManager _instance = new FortSiegeManager();

        private SingletonHolder() {
        }
    }

    public static class SiegeSpawn {
        Location _location;
        private int _npcId;
        private int _heading;
        private int _fortId;
        private int _id;

        public SiegeSpawn(int fort_id, int x, int y, int z, int heading, int npc_id, int id) {
            this._fortId = fort_id;
            this._location = new Location(x, y, z, heading);
            this._heading = heading;
            this._npcId = npc_id;
            this._id = id;
        }

        public int getFortId() {
            return this._fortId;
        }

        public int getNpcId() {
            return this._npcId;
        }

        public int getHeading() {
            return this._heading;
        }

        public int getId() {
            return this._id;
        }

        public Location getLocation() {
            return this._location;
        }
    }
}

