/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.clanhall.ClanHallSiegeEngine;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.type.L2SiegableHallZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class CHSiegeManager {
    private static final Logger _log = Logger.getLogger(CHSiegeManager.class.getName());
    private static final String SQL_LOAD_HALLS = "SELECT * FROM siegable_clanhall";
    private FastMap<Integer, SiegableHall> _siegableHalls = new FastMap();

    private CHSiegeManager() {
        _log.info("Initializing CHSiegeManager...");
        this.loadClanHalls();
    }

    public static CHSiegeManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadClanHalls() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SQL_LOAD_HALLS);
            ResultSet rs = statement.executeQuery();
            this._siegableHalls.clear();
            while (rs.next()) {
                int id = rs.getInt("clanHallId");
                StatsSet set = new StatsSet();
                set.set("id", id);
                set.set("name", rs.getString("name"));
                set.set("ownerId", rs.getInt("ownerId"));
                set.set("desc", rs.getString("desc"));
                set.set("location", rs.getString("location"));
                set.set("nextSiege", rs.getLong("nextSiege"));
                set.set("siegeLenght", rs.getLong("siegeLenght"));
                set.set("scheduleConfig", rs.getString("schedule_config"));
                SiegableHall hall = new SiegableHall(set);
                this._siegableHalls.put((Object)id, (Object)hall);
                ClanHallManager.addClanHall(hall);
            }
            _log.config("CHSiegeManager: Loaded " + this._siegableHalls.size() + " conquerable clan halls");
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("CHSiegeManager: Could not load siegable clan halls!:");
            e.printStackTrace();
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public FastMap<Integer, SiegableHall> getConquerableHalls() {
        return this._siegableHalls;
    }

    public SiegableHall getSiegableHall(int clanHall) {
        return (SiegableHall)this.getConquerableHalls().get((Object)clanHall);
    }

    public final SiegableHall getNearbyClanHall(L2Character activeChar) {
        return this.getNearbyClanHall(activeChar.getX(), activeChar.getY(), 10000);
    }

    public final SiegableHall getNearbyClanHall(int x, int y, int maxDist) {
        L2SiegableHallZone zone = null;
        for (Map.Entry ch : this._siegableHalls.entrySet()) {
            zone = ((SiegableHall)ch.getValue()).getZone();
            if (zone == null || !(zone.getDistanceToZone(x, y) < (double)maxDist)) continue;
            return (SiegableHall)ch.getValue();
        }
        return null;
    }

    public final ClanHallSiegeEngine getSiege(L2Character character) {
        SiegableHall hall = this.getNearbyClanHall(character);
        if (hall == null) {
            return null;
        }
        return hall.getSiege();
    }

    public final void registerClan(L2Clan clan, SiegableHall hall, L2PcInstance player) {
        if (clan.getLevel() < Config.CHS_CLAN_MINLEVEL) {
            player.sendMessage("Only clans of level " + Config.CHS_CLAN_MINLEVEL + " or higher may register for a castle siege");
        } else if (hall.isWaitingBattle()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEADLINE_FOR_SIEGE_S1_PASSED);
            sm.addSiegableHallName(hall);
            player.sendPacket(sm);
        } else if (hall.isInSiege()) {
            player.sendPacket(SystemMessageId.NOT_SIEGE_REGISTRATION_TIME2);
        } else if (hall.getOwnerId() == clan.getClanId()) {
            player.sendPacket(SystemMessageId.CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING);
        } else if (clan.getHasCastle() != 0 || clan.getHasHideout() != 0) {
            player.sendPacket(SystemMessageId.CLAN_THAT_OWNS_CASTLE_CANNOT_PARTICIPATE_OTHER_SIEGE);
        } else if (hall.getSiege().checkIsAttacker(clan)) {
            player.sendPacket(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE);
        } else if (this.isClanParticipating(clan)) {
            player.sendPacket(SystemMessageId.APPLICATION_DENIED_BECAUSE_ALREADY_SUBMITTED_A_REQUEST_FOR_ANOTHER_SIEGE_BATTLE);
        } else if (hall.getSiege().getAttackers().size() >= Config.CHS_MAX_ATTACKERS) {
            player.sendPacket(SystemMessageId.ATTACKER_SIDE_FULL);
        } else {
            hall.addAttacker(clan);
        }
    }

    public final void unRegisterClan(L2Clan clan, SiegableHall hall) {
        if (!hall.isRegistering()) {
            return;
        }
        hall.removeAttacker(clan);
    }

    public final boolean isClanParticipating(L2Clan clan) {
        for (SiegableHall hall : this.getConquerableHalls().values()) {
            if (hall.getSiege() == null || !hall.getSiege().checkIsAttacker(clan)) continue;
            return true;
        }
        return false;
    }

    public final void onServerShutDown() {
        for (SiegableHall hall : this.getConquerableHalls().values()) {
            if (hall.getId() == 62 || hall.getSiege() == null) continue;
            hall.getSiege().saveAttackers();
        }
    }

    private static final class SingletonHolder {
        private static final CHSiegeManager INSTANCE = new CHSiegeManager();

        private SingletonHolder() {
        }
    }
}

