/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticObjects {
    private static Logger _log = Logger.getLogger(StaticObjects.class.getName());
    private TIntObjectHashMap<L2StaticObjectInstance> _staticObjects = new TIntObjectHashMap();

    public static StaticObjects getInstance() {
        return SingletonHolder._instance;
    }

    private StaticObjects() {
        this.parseData();
        _log.info("StaticObject: Loaded " + this._staticObjects.size() + " StaticObject Templates.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseData() {
        BufferedReader lnr = null;
        try {
            File doorData = new File(Config.DATAPACK_ROOT, "data/staticobjects.csv");
            lnr = new LineNumberReader(new BufferedReader(new FileReader(doorData)));
            String line = null;
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                L2StaticObjectInstance obj = StaticObjects.parse(line);
                this._staticObjects.put(obj.getStaticObjectId(), (Object)obj);
            }
        }
        catch (FileNotFoundException e) {
            _log.warning("staticobjects.csv is missing in data folder");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while creating StaticObjects table " + e.getMessage(), e);
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e) {}
        }
    }

    public static L2StaticObjectInstance parse(String line) {
        StringTokenizer st = new StringTokenizer(line, ";");
        st.nextToken();
        int id = Integer.parseInt(st.nextToken());
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        int z = Integer.parseInt(st.nextToken());
        int type = Integer.parseInt(st.nextToken());
        String texture = st.nextToken();
        int map_x = Integer.parseInt(st.nextToken());
        int map_y = Integer.parseInt(st.nextToken());
        StatsSet npcDat = new StatsSet();
        npcDat.set("npcId", id);
        npcDat.set("level", 0);
        npcDat.set("jClass", "staticobject");
        npcDat.set("baseSTR", 0);
        npcDat.set("baseCON", 0);
        npcDat.set("baseDEX", 0);
        npcDat.set("baseINT", 0);
        npcDat.set("baseWIT", 0);
        npcDat.set("baseMEN", 0);
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseAccCombat", 38);
        npcDat.set("baseEvasRate", 38);
        npcDat.set("baseCritRate", 38);
        npcDat.set("collision_radius", 10);
        npcDat.set("collision_height", 10);
        npcDat.set("sex", "male");
        npcDat.set("type", "");
        npcDat.set("baseAtkRange", 0);
        npcDat.set("baseMpMax", 0);
        npcDat.set("baseCpMax", 0);
        npcDat.set("rewardExp", 0);
        npcDat.set("rewardSp", 0);
        npcDat.set("basePAtk", 0);
        npcDat.set("baseMAtk", 0);
        npcDat.set("basePAtkSpd", 0);
        npcDat.set("aggroRange", 0);
        npcDat.set("baseMAtkSpd", 0);
        npcDat.set("rhand", 0);
        npcDat.set("lhand", 0);
        npcDat.set("armor", 0);
        npcDat.set("baseWalkSpd", 0);
        npcDat.set("baseRunSpd", 0);
        npcDat.set("name", "");
        npcDat.set("baseHpMax", 1);
        npcDat.set("baseHpReg", 0.003f);
        npcDat.set("baseMpReg", 0.003f);
        npcDat.set("basePDef", 1);
        npcDat.set("baseMDef", 1);
        L2CharTemplate template = new L2CharTemplate(npcDat);
        L2StaticObjectInstance obj = new L2StaticObjectInstance(IdFactory.getInstance().getNextId(), template, id);
        obj.setType(type);
        obj.setXYZ(x, y, z);
        obj.setMap(texture, map_x, map_y);
        obj.spawnMe();
        return obj;
    }

    public void putObject(L2StaticObjectInstance obj) {
        this._staticObjects.put(obj.getStaticObjectId(), (Object)obj);
    }

    private static class SingletonHolder {
        protected static final StaticObjects _instance = new StaticObjects();

        private SingletonHolder() {
        }
    }
}

