/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.script.DateRange;
import java.util.Date;
import java.util.List;
import javolution.util.FastList;

public class EventDroplist {
    private List<DateDrop> _allNpcDateDrops = new FastList();

    public static EventDroplist getInstance() {
        return SingletonHolder._instance;
    }

    private EventDroplist() {
    }

    public void addGlobalDrop(int[] items, int[] count, int chance, DateRange range) {
        DateDrop date = new DateDrop();
        date.dateRange = range;
        date.items = items;
        date.min = count[0];
        date.max = count[1];
        date.chance = chance;
        this._allNpcDateDrops.add(date);
    }

    public List<DateDrop> getAllDrops() {
        FastList list = new FastList();
        for (DateDrop drop : this._allNpcDateDrops) {
            Date currentDate = new Date();
            if (!drop.dateRange.isWithinRange(currentDate)) continue;
            list.add(drop);
        }
        return list;
    }

    private static class SingletonHolder {
        protected static final EventDroplist _instance = new EventDroplist();

        private SingletonHolder() {
        }
    }

    public static class DateDrop {
        public DateRange dateRange;
        public int[] items;
        public int min;
        public int max;
        public int chance;
    }
}

