/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.communitybbs.Manager.BaseBBSManager;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ShowBoard;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastList;

public class RegionBBSManager
extends BaseBBSManager {
    private static Logger _logChat = Logger.getLogger("chat");
    private static final int[] _onlineCounts = new int[2];
    private static final int FOR_PLAYER = 0;
    private static final int FOR_GM = 1;
    private static final FastList<String>[] _communityPages = new FastList[2];
    private static final String DATEFORMAT = "yyyy/MM/dd HH:mm";
    private static final String SHORTFORMAT = "H\u6642 mm\u5206";

    private RegionBBSManager() {
    }

    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        if (command.equals("_bbsloc")) {
            this.showOldCommunity(activeChar, 1);
        } else if (command.startsWith("_bbsloc;page;")) {
            StringTokenizer st = new StringTokenizer(command, ";");
            st.nextToken();
            st.nextToken();
            int page = 0;
            try {
                page = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showOldCommunity(activeChar, page);
        } else if (command.startsWith("_bbsloc;playerinfo;")) {
            StringTokenizer st = new StringTokenizer(command, ";");
            st.nextToken();
            st.nextToken();
            String name = st.nextToken();
            this.showOldCommunityPI(activeChar, name);
        } else if (Config.COMMUNITY_TYPE == 1) {
            this.showOldCommunity(activeChar, 1);
        } else {
            ShowBoard sb = new ShowBoard("<html><body><br><br><center>\u30b3\u30de\u30f3\u30c9\uff1a " + command + " \u306f\u672a\u5b9f\u88c5\u3067\u3059\u3002</center><br><br></body></html>", "101");
            activeChar.sendPacket(sb);
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        }
    }

    private void showOldCommunityPI(L2PcInstance activeChar, String name) {
        StringBuilder htmlCode = StringUtil.startAppend(1000, "<html><body><br><table border=0><tr><td FIXWIDTH=15></td><td align=center>L2J Community Board<img src=\"sek.cbui355\" width=610 height=1></td></tr><tr><td FIXWIDTH=15></td><td>");
        L2PcInstance player = L2World.getInstance().getPlayer(name);
        if (player != null) {
            String sex = "\u7537\u6027";
            if (player.getAppearance().getSex()) {
                sex = "\u5973\u6027";
            }
            String levelApprox = "\u4f4e\u3044";
            if (player.getLevel() >= 60) {
                levelApprox = "\u975e\u5e38\u306b\u9ad8\u3044";
            } else if (player.getLevel() >= 40) {
                levelApprox = "\u9ad8\u3044";
            } else if (player.getLevel() >= 20) {
                levelApprox = "\u4e2d\u304f\u3089\u3044";
            }
            StringUtil.append(htmlCode, "<table border=0><tr><td>", player.getName(), " (", sex, " ", player.getTemplate().className, "):</td></tr><tr><td>\u30ec\u30d9\u30eb: ", levelApprox, "</td></tr><tr><td><br></td></tr>");
            if (activeChar != null && (activeChar.isGM() || player.getObjectId() == activeChar.getObjectId() || Config.SHOW_LEVEL_COMMUNITYBOARD)) {
                int level = player.getLevel();
                long currentExp = player.getExp() - ExperienceTable.getInstance().getExpForLevel(level);
                long nextLevelExp = ExperienceTable.getInstance().getExpForLevel(level + 1) - ExperienceTable.getInstance().getExpForLevel(level);
                long nextLevelExpNeeded = nextLevelExp - currentExp;
                double perExp = (double)currentExp / (double)nextLevelExp;
                DecimalFormat dfExp = new DecimalFormat("0.00%");
                dfExp.setRoundingMode(RoundingMode.DOWN);
                StringUtil.append(htmlCode, "<tr><td>\u73fe\u5728\u306e\u30ec\u30d9\u30eb: ", String.valueOf(level), "</td></tr><tr><td>\u73fe\u5728\u306e\u7d4c\u9a13\u5024: ", String.valueOf(currentExp), "/", String.valueOf(nextLevelExp), " (", dfExp.format(new BigDecimal(perExp)), ")</td></tr><tr><td>\u6b21\u306eLvUP\u306b\u5fc5\u8981\u306a\u7d4c\u9a13\u5024: ", String.valueOf(nextLevelExpNeeded), "</td></tr><tr><td><br></td></tr>");
            }
            StringUtil.append(htmlCode, "<tr><td>\u30d7\u30ec\u30a4\u6642\u9593\uff1a ", Util.strTime((int)(player.getUptime() / 1000L)), "</td></tr><tr><td><br></td></tr>");
            if (player.getClan() != null) {
                StringUtil.append(htmlCode, "<tr><td>\u6240\u5c5e\u8840\u76df: ", player.getClan().getName(), "</td></tr><tr><td><br></td></tr>");
            }
            StringUtil.append(htmlCode, "<tr><td><multiedit var=\"pm\" width=240 height=40><button value=\"\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\" action=\"Write Region PM ", player.getName(), " pm pm pm\" width=110 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr>");
            if (activeChar.isGM()) {
                StringUtil.append(htmlCode, "<tr><td><br><button value=\"\u5f37\u5236\u547c\u51fa\" action=\"bypass -h admin_recall ", player.getName(), "\" width=80 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr>");
                if (player.getParty() != null) {
                    StringUtil.append(htmlCode, "<tr><td><br><button value=\"\uff30\uff34\u547c\u51fa\" action=\"bypass -h admin_recall_pt ", player.getName(), "\" width=80 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr>");
                }
                StringUtil.append(htmlCode, "<tr><td><br><button value=\"\u81ea\u5df1\u8ee2\u9001\" action=\"bypass -h admin_teleportto ", player.getName(), "\" width=80 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr>");
            }
            StringUtil.append(htmlCode, "<tr><td><br><button value=\"\u623b\u308b\" action=\"bypass _bbsloc\" width=40 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr></table></td></tr></table></body></html>");
            this.separateAndSend(htmlCode.toString(), activeChar);
        } else {
            ShowBoard sb = new ShowBoard(StringUtil.concat("<html><body><br><br><center>\u30d7\u30ec\u30a4\u30e4\u30fc: ", name, "\u306f\u30aa\u30d5\u30e9\u30a4\u30f3\u3067\u3059\u3002</center><br><br></body></html>"), "101");
            activeChar.sendPacket(sb);
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        }
    }

    private void showOldCommunity(L2PcInstance activeChar, int page) {
        this.separateAndSend(this.getCommunityPage(page, activeChar.isGM() ? 1 : 0), activeChar);
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
        block12: {
            if (activeChar == null) {
                return;
            }
            if (ar1.equals("PM")) {
                StringBuilder htmlCode = StringUtil.startAppend(500, "<html><body><br><table border=0><tr><td FIXWIDTH=15></td><td align=center>L2J \u30b3\u30df\u30e5\u30cb\u30c6\u30a3<img src=\"sek.cbui355\" width=610 height=1></td></tr><tr><td FIXWIDTH=15></td><td>");
                try {
                    L2PcInstance receiver = L2World.getInstance().getPlayer(ar2);
                    if (receiver == null) {
                        StringUtil.append(htmlCode, "\u76f8\u624b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002<br><button value=\"\u623b\u308b\" action=\"bypass _bbsloc;playerinfo;", ar2, "\" width=40 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr></table></body></html>");
                        this.separateAndSend(htmlCode.toString(), activeChar);
                        return;
                    }
                    if (Config.JAIL_DISABLE_CHAT && receiver.isInJail()) {
                        activeChar.sendMessage("\u76f8\u624b\u306fGM\u76f8\u8ac7\u6240\u306b\u5c45\u307e\u3059\u3002");
                        return;
                    }
                    if (receiver.isChatBanned()) {
                        activeChar.sendPacket(SystemMessageId.TARGET_IS_CHAT_BANNED);
                        return;
                    }
                    if (activeChar.isInJail() && Config.JAIL_DISABLE_CHAT) {
                        activeChar.sendMessage("GM\u76f8\u8ac7\u6240\u3067\u306f\u30c1\u30e3\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002");
                        return;
                    }
                    if (activeChar.isChatBanned()) {
                        activeChar.sendPacket(SystemMessageId.CHATTING_IS_CURRENTLY_PROHIBITED);
                        return;
                    }
                    if (Config.LOG_CHAT) {
                        LogRecord record = new LogRecord(Level.INFO, ar3);
                        record.setLoggerName("chat");
                        record.setParameters(new Object[]{"TELL", "[" + activeChar.getName() + " to " + receiver.getName() + "]"});
                        _logChat.log(record);
                    }
                    CreatureSay cs = new CreatureSay(activeChar.getObjectId(), 2, activeChar.getName(), ar3);
                    if (!receiver.isSilenceMode(activeChar.getObjectId()) && !BlockList.isBlocked(receiver, activeChar)) {
                        receiver.sendPacket(cs);
                        activeChar.sendPacket(new CreatureSay(activeChar.getObjectId(), 2, "->" + receiver.getName(), ar3));
                        StringUtil.append(htmlCode, "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002<br><button value=\"\u623b\u308b\" action=\"bypass _bbsloc;playerinfo;", receiver.getName(), "\" width=40 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td></tr></table></body></html>");
                        this.separateAndSend(htmlCode.toString(), activeChar);
                        break block12;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_PERSON_IS_IN_MESSAGE_REFUSAL_MODE);
                    activeChar.sendPacket(sm);
                    this.parsecmd("_bbsloc;playerinfo;" + receiver.getName(), activeChar);
                }
                catch (StringIndexOutOfBoundsException e) {}
            } else {
                ShowBoard sb = new ShowBoard(StringUtil.concat("<html><body><br><br><center>\u30b3\u30de\u30f3\u30c9\uff1a ", ar1, " \u306f\u672a\u5b9f\u88c5\u3067\u3059\u3002</center><br><br></body></html>"), "101");
                activeChar.sendPacket(sb);
                activeChar.sendPacket(new ShowBoard(null, "102"));
                activeChar.sendPacket(new ShowBoard(null, "103"));
            }
        }
    }

    public static RegionBBSManager getInstance() {
        return SingletonHolder._instance;
    }

    public void changeCommunityBoard() {
        FastList sortedPlayers = new FastList();
        Collections.addAll(sortedPlayers, L2World.getInstance().getAllPlayersArray());
        Collections.sort(sortedPlayers, new Comparator<L2PcInstance>(){

            @Override
            public int compare(L2PcInstance p1, L2PcInstance p2) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });
        RegionBBSManager._onlineCounts[0] = 0;
        RegionBBSManager._onlineCounts[1] = 0;
        for (L2PcInstance player : sortedPlayers) {
            this.addOnlinePlayer(player);
        }
        _communityPages[0].clear();
        _communityPages[1].clear();
        this.writeCommunityPages((FastList<L2PcInstance>)sortedPlayers);
    }

    private void addOnlinePlayer(L2PcInstance player) {
        _onlineCounts[1] = _onlineCounts[1] + 1;
        if (!player.getAppearance().getInvisible()) {
            _onlineCounts[0] = _onlineCounts[0] + 1;
        }
    }

    private void writeCommunityPages(FastList<L2PcInstance> sortedPlayers) {
        String trOpen = "<tr>";
        String trClose = "</tr>";
        String tdOpen = "<td align=left valign=top>";
        String colSpacer = "<td FIXWIDTH=15></td>";
        String tdClose = "</td>";
        for (int type = 0; type <= 1; ++type) {
            StringBuilder htmlCode = new StringBuilder(2000);
            StringUtil.append(htmlCode, "<html><body><br><center><table width=80><tr><td width=80><img src=l2ui.bbs_lineage2 height=16 width=80></td></tr><tr><td height=12></td></tr></table><center><img src=\"sek.cbui355\" width=\"610\" height=\"1\"><br><table width=630><tr><td align=left valign=top>\u30b2\u30fc\u30e0\u5185\u6642\u523b: %gametime%</td><td align=left valign=top>\u30b5\u30fc\u30d0\u30fc\u5b9f\u6642\u523b: %realtime%</td><td align=left valign=top>\u30b5\u30fc\u30d0\u30fc\u8d77\u52d5\u65e5\u6642: ", new SimpleDateFormat(DATEFORMAT).format(GameServer.gameServer.serverLoadEnd), "</td></tr></table><table width=630><tr><td align=left valign=top>\u53d6\u5f97\u7d4c\u9a13\u5024\u500d\u7387: ", String.valueOf(Config.RATE_XP), "</td><td FIXWIDTH=15></td><td align=left valign=top>", "PT\u7d4c\u9a13\u5024\u30dc\u30fc\u30ca\u30b9\u500d\u7387: ", String.valueOf(Config.RATE_XP * Config.RATE_PARTY_XP), "</td><td FIXWIDTH=15></td><td align=left valign=top>", "Lv\u5dee\u7d4c\u9a13\u5024\u30dc\u30fc\u30ca\u30b9\u500d\u7387: ", String.valueOf(Config.ALT_GAME_EXPONENT_XP), "</td></tr><tr><td align=left valign=top>", "\u53d6\u5f97SP\u500d\u7387: ", String.valueOf(Config.RATE_SP), "</td><td FIXWIDTH=15></td><td align=left valign=top>", "PT SP\u30dc\u30fc\u30ca\u30b9\u500d\u7387: ", String.valueOf(Config.RATE_SP * Config.RATE_PARTY_SP), "</td><td FIXWIDTH=15></td><td align=left valign=top>", "Lv\u5deeSP\u30dc\u30fc\u30ca\u30b9\u500d\u7387: ", String.valueOf(Config.ALT_GAME_EXPONENT_SP), "</td></tr><tr><td align=left valign=top>", "\u30c9\u30ed\u30c3\u30d7\u500d\u7387: ", String.valueOf(Config.RATE_DROP_ITEMS), "</td><td FIXWIDTH=15></td><td align=left valign=top>", "\u30b9\u30dd\u30a4\u30eb\u500d\u7387: ", String.valueOf(Config.RATE_DROP_SPOIL), "</td><td FIXWIDTH=15></td><td align=left valign=top>", "\u30a2\u30c7\u30ca\u500d\u7387: ", String.valueOf(Config.RATE_DROP_ITEMS_ID.get(57)), "</td></tr></table><br><img src=\"sek.cbui355\" width=610 height=1><br>");
            if (type == 1) {
                StringUtil.append(htmlCode, String.valueOf(L2World.getInstance().getAllVisibleObjectsCount()), " \u4f53\u306eNPC\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002<br1>");
            }
            StringUtil.append(htmlCode, String.valueOf(_onlineCounts[type]), " \u540d\u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u304c\u30aa\u30f3\u30e9\u30a4\u30f3\u3067\u3059\u3002<br1>");
            if (Config.BBS_SHOW_PLAYERLIST) {
                StringUtil.append(htmlCode, "\uff08GM\u30d7\u30ec\u30a4\u30e4\u30fc\u540d\u306f\u9ec4\u8272\u3067\u8868\u8a18\uff09<br1>");
            }
            StringBuilder htmlHeader = new StringBuilder(htmlCode);
            htmlCode = null;
            FastList pages = new FastList();
            if (Config.BBS_SHOW_PLAYERLIST) {
                int[] cells = new int[sortedPlayers.size() / Config.NAME_PAGE_SIZE_COMMUNITYBOARD + 3];
                int page = 0;
                int cell = 0;
                String tableOpen_1 = "<table border=0>";
                String trOpen_2 = "<tr>";
                String colSpacer_2 = "<td FIXWIDTH=15></td>";
                String trClose_2 = "</tr>";
                String tableClose_1 = "</table><hr>";
                for (L2PcInstance player : sortedPlayers) {
                    if (type == 0 && player.getAppearance().getInvisible()) continue;
                    if (++cell == 1) {
                        ++page;
                        htmlCode = new StringBuilder(htmlHeader.length() + 2000).append((CharSequence)htmlHeader).append("<table border=0>");
                    }
                    if (cell % Config.NAME_PER_ROW_COMMUNITYBOARD == 1) {
                        htmlCode.append("<tr>");
                    }
                    StringUtil.append(htmlCode, "<td align=left valign=top FIXWIDTH=110><a action=\"bypass _bbsloc;playerinfo;", player.getName(), "\">");
                    if (player.isGM()) {
                        StringUtil.append(htmlCode, "<font color=\"LEVEL\">", player.getName(), "</font>");
                    } else if (Config.OFFLINE_SET_NAME_COLOR && (player.getClient() == null || player.getClient().isDetached())) {
                        StringUtil.append(htmlCode, "<font color=\"", String.valueOf(Config.OFFLINE_NAME_COLOR), "\">", player.getName(), "</font>");
                    } else {
                        htmlCode.append(player.getName());
                    }
                    htmlCode.append("</a></td>");
                    if (cell % Config.NAME_PER_ROW_COMMUNITYBOARD == 0) {
                        htmlCode.append("</tr>");
                    } else {
                        htmlCode.append("<td FIXWIDTH=15></td>");
                    }
                    if (cell != Config.NAME_PAGE_SIZE_COMMUNITYBOARD) continue;
                    htmlCode.append("</table><hr>");
                    pages.add((Object)htmlCode);
                    htmlCode = null;
                    cells[page] = cell;
                    cell = 0;
                }
                if (cell % Config.NAME_PER_ROW_COMMUNITYBOARD != 0) {
                    htmlCode.append("</tr>");
                }
                if (cell > 0) {
                    htmlCode.append("</table><hr>");
                    pages.add((Object)htmlCode);
                    htmlCode = null;
                    cells[page] = cell;
                    cell = 0;
                }
                if (pages.size() >= 2) {
                    page = 0;
                    Iterator i$ = pages.iterator();
                    while (i$.hasNext()) {
                        StringBuilder html;
                        htmlCode = html = (StringBuilder)i$.next();
                        htmlCode.append("<br1><table border=0 width=600><tr>");
                        if (++page == 1) {
                            htmlCode.append("<td align=right width=190></td>");
                        } else {
                            StringUtil.append(htmlCode, "<td align=right width=190><button value=\"\u524d\u3078\" action=\"bypass _bbsloc;page;", String.valueOf(page - 1), "\" width=50 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td>");
                        }
                        htmlCode.append("<td FIXWIDTH=10></td>");
                        int n1 = (page - 1) * Config.NAME_PAGE_SIZE_COMMUNITYBOARD + 1;
                        int n2 = (page - 1) * Config.NAME_PAGE_SIZE_COMMUNITYBOARD + cells[page];
                        StringUtil.append(htmlCode, "<td align=center valign=top width=200>", String.valueOf(n1), " - ", String.valueOf(n2), " \u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u3092\u8868\u793a\u4e2d</td><td FIXWIDTH=10></td>");
                        if (page == pages.size()) {
                            htmlCode.append("<td width=190></td>");
                        } else {
                            StringUtil.append(htmlCode, "<td width=190><button value=\"\u6b21\u3078\" action=\"bypass _bbsloc;page;", String.valueOf(page + 1), "\" width=50 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\"></td>");
                        }
                        htmlCode.append("</tr></table>");
                    }
                }
            }
            if (pages.size() == 0) {
                pages.add((Object)htmlHeader);
            }
            Iterator i$ = pages.iterator();
            while (i$.hasNext()) {
                StringBuilder html;
                htmlCode = html = (StringBuilder)i$.next();
                htmlCode.append("</body></html>");
                _communityPages[type].add((Object)new String(htmlCode));
            }
        }
    }

    private String getCommunityPage(int page, int type) {
        FastList<String> pages = _communityPages[type];
        if (page < 1) {
            page = 1;
        }
        if (page > pages.size()) {
            page = pages.size();
        }
        Calendar realtime = Calendar.getInstance();
        Calendar gametime = Calendar.getInstance();
        int t = GameTimeController.getInstance().getGameTime();
        gametime.set(11, t / 60);
        gametime.set(12, t % 60);
        return ((String)pages.get(page - 1)).replaceFirst("%gametime%", new SimpleDateFormat(SHORTFORMAT).format(gametime.getTime())).replaceFirst("%realtime%", new SimpleDateFormat(DATEFORMAT).format(realtime.getTime()));
    }

    static {
        RegionBBSManager._communityPages[0] = new FastList();
        RegionBBSManager._communityPages[1] = new FastList();
    }

    private static class SingletonHolder {
        protected static final RegionBBSManager _instance = new RegionBBSManager();

        private SingletonHolder() {
        }
    }
}

