/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import java.util.ArrayList;

public class NextAction {
    private ArrayList<CtrlEvent> _events;
    private ArrayList<CtrlIntention> _intentions;
    private NextActionCallback _callback;

    public NextAction(ArrayList<CtrlEvent> events, ArrayList<CtrlIntention> intentions, NextActionCallback callback) {
        this._events = events;
        this._intentions = intentions;
        this.setCallback(callback);
    }

    public NextAction(CtrlEvent event, CtrlIntention intention, NextActionCallback callback) {
        if (this._events == null) {
            this._events = new ArrayList();
        }
        if (this._intentions == null) {
            this._intentions = new ArrayList();
        }
        if (event != null) {
            this._events.add(event);
        }
        if (intention != null) {
            this._intentions.add(intention);
        }
        this.setCallback(callback);
    }

    public void doAction() {
        if (this._callback != null) {
            this._callback.doWork();
        }
    }

    public ArrayList<CtrlEvent> getEvents() {
        if (this._events == null) {
            this._events = new ArrayList();
        }
        return this._events;
    }

    public void setEvents(ArrayList<CtrlEvent> event) {
        this._events = event;
    }

    public void addEvent(CtrlEvent event) {
        if (this._events == null) {
            this._events = new ArrayList();
        }
        if (event != null) {
            this._events.add(event);
        }
    }

    public void removeEvent(CtrlEvent event) {
        if (this._events == null) {
            return;
        }
        this._events.remove((Object)event);
    }

    public NextActionCallback getCallback() {
        return this._callback;
    }

    public void setCallback(NextActionCallback callback) {
        this._callback = callback;
    }

    public ArrayList<CtrlIntention> getIntentions() {
        if (this._intentions == null) {
            this._intentions = new ArrayList();
        }
        return this._intentions;
    }

    public void setIntentions(ArrayList<CtrlIntention> intentions) {
        this._intentions = intentions;
    }

    public void addIntention(CtrlIntention intention) {
        if (this._intentions == null) {
            this._intentions = new ArrayList();
        }
        if (intention != null) {
            this._intentions.add(intention);
        }
    }

    public void removeIntention(CtrlIntention intention) {
        if (this._intentions == null) {
            return;
        }
        this._intentions.remove((Object)intention);
    }

    public static interface NextActionCallback {
        public void doWork();
    }
}

