/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class TradeController {
    private static Logger _log = Logger.getLogger(TradeController.class.getName());
    private int _nextListId;
    private Map<Integer, L2TradeList> _lists = new FastMap();

    public static TradeController getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TradeController() {
        this._lists.clear();
        Connection con = null;
        StringIntern.begin();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("SELECT  shop_id, npc_id FROM merchant_shopids");
            ResultSet rset1 = statement1.executeQuery();
            PreparedStatement statement = con.prepareStatement("SELECT item_id, price, shop_id, " + L2DatabaseFactory.getInstance().safetyString("order") + ", count, currentCount, time, savetimer FROM merchant_buylists WHERE shop_id=? ORDER BY " + L2DatabaseFactory.getInstance().safetyString("order") + " ASC");
            while (rset1.next()) {
                statement.setString(1, String.valueOf(rset1.getInt("shop_id")));
                ResultSet rset = statement.executeQuery();
                statement.clearParameters();
                int shopId = rset1.getInt("shop_id");
                L2TradeList buy1 = new L2TradeList(shopId);
                while (rset.next()) {
                    double diff;
                    int itemId = rset.getInt("item_id");
                    int price = rset.getInt("price");
                    int maxCount = rset.getInt("count");
                    int currentCount = rset.getInt("currentCount");
                    int time = rset.getInt("time");
                    long saveTimer = rset.getLong("saveTimer");
                    L2TradeList.L2TradeItem item = new L2TradeList.L2TradeItem(shopId, itemId);
                    if (ItemTable.getInstance().getTemplate(itemId) == null) {
                        _log.warning("Skipping itemId: " + itemId + " on buylistId: " + buy1.getListId() + ", missing data for that item.");
                        continue;
                    }
                    if (price <= -1) {
                        price = ItemTable.getInstance().getTemplate(itemId).getReferencePrice();
                    }
                    if (Config.DEBUG && ((diff = (double)price / (double)ItemTable.getInstance().getTemplate(itemId).getReferencePrice()) < 0.8 || diff > 1.2)) {
                        _log.severe("PRICING DEBUG: TradeListId: " + buy1.getListId() + " -  ItemId: " + itemId + " (" + ItemTable.getInstance().getTemplate(itemId).getName() + ") diff: " + diff + " - Price: " + price + " - Reference: " + ItemTable.getInstance().getTemplate(itemId).getReferencePrice());
                    }
                    item.setPrice(price);
                    item.setRestoreDelay(time);
                    item.setNextRestoreTime(saveTimer);
                    item.setMaxCount(maxCount);
                    if (currentCount > -1) {
                        item.setCurrentCount(currentCount);
                    } else {
                        item.setCurrentCount(maxCount);
                    }
                    buy1.addItem(item);
                }
                buy1.setNpcId(StringIntern.intern(rset1.getString("npc_id")));
                this._lists.put(buy1.getListId(), buy1);
                this._nextListId = Math.max(this._nextListId, buy1.getListId() + 1);
                rset.close();
            }
            statement.close();
            rset1.close();
            statement1.close();
            _log.info("TradeController: Loaded " + this._lists.size() + " Buylists.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "TradeController: Buylists could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        if (Config.CUSTOM_MERCHANT_TABLES) {
            try {
                int initialSize = this._lists.size();
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement1 = con.prepareStatement("SELECT  shop_id, npc_id FROM custom_merchant_shopids");
                ResultSet rset1 = statement1.executeQuery();
                PreparedStatement statement = con.prepareStatement("SELECT item_id, price, shop_id, " + L2DatabaseFactory.getInstance().safetyString("order") + ", count, currentCount, time, savetimer FROM custom_merchant_buylists WHERE shop_id=? ORDER BY " + L2DatabaseFactory.getInstance().safetyString("order") + " ASC");
                while (rset1.next()) {
                    statement.setString(1, String.valueOf(rset1.getInt("shop_id")));
                    ResultSet rset = statement.executeQuery();
                    statement.clearParameters();
                    int shopId = rset1.getInt("shop_id");
                    L2TradeList buy1 = new L2TradeList(shopId);
                    while (rset.next()) {
                        double diff;
                        int itemId = rset.getInt("item_id");
                        int price = rset.getInt("price");
                        int maxCount = rset.getInt("count");
                        int currentCount = rset.getInt("currentCount");
                        int time = rset.getInt("time");
                        long saveTimer = rset.getLong("saveTimer");
                        L2TradeList.L2TradeItem item = new L2TradeList.L2TradeItem(shopId, itemId);
                        if (ItemTable.getInstance().getTemplate(itemId) == null) {
                            _log.warning("Skipping itemId: " + itemId + " on buylistId: " + buy1.getListId() + ", missing data for that item.");
                            continue;
                        }
                        if (price <= -1) {
                            price = ItemTable.getInstance().getTemplate(itemId).getReferencePrice();
                        }
                        if (Config.DEBUG && ((diff = (double)price / (double)ItemTable.getInstance().getTemplate(itemId).getReferencePrice()) < 0.8 || diff > 1.2)) {
                            _log.severe("PRICING DEBUG: TradeListId: " + buy1.getListId() + " -  ItemId: " + itemId + " (" + ItemTable.getInstance().getTemplate(itemId).getName() + ") diff: " + diff + " - Price: " + price + " - Reference: " + ItemTable.getInstance().getTemplate(itemId).getReferencePrice());
                        }
                        item.setPrice(price);
                        item.setRestoreDelay(time);
                        item.setNextRestoreTime(saveTimer);
                        item.setMaxCount(maxCount);
                        if (currentCount > -1) {
                            item.setCurrentCount(currentCount);
                        } else {
                            item.setCurrentCount(maxCount);
                        }
                        buy1.addItem(item);
                    }
                    buy1.setNpcId(rset1.getString("npc_id"));
                    this._lists.put(buy1.getListId(), buy1);
                    this._nextListId = Math.max(this._nextListId, buy1.getListId() + 1);
                    rset.close();
                }
                statement.close();
                rset1.close();
                statement1.close();
                _log.info("TradeController: Loaded " + (this._lists.size() - initialSize) + " Custom Buylists.");
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "TradeController: Buylists could not be initialized: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
        StringIntern.end();
    }

    public void checkAllPrice() {
        for (L2TradeList list : this._lists.values()) {
            for (L2TradeList.L2TradeItem tradeItem : list.getItems()) {
                L2Item itemTemplate = ItemTable.getInstance().getTemplate(tradeItem.getItemId());
                long sellPrice = itemTemplate.getReferencePrice() / 2;
                long buyPrice = tradeItem.getPrice();
                if (0L >= buyPrice || buyPrice >= sellPrice) continue;
                String npcId = list.getNpcId();
                String npcName = "";
                try {
                    npcName = NpcTable.getInstance().getTemplate(Integer.parseInt(npcId)).getName();
                }
                catch (NumberFormatException e) {
                    npcId = "";
                    npcName = list.getNpcId();
                }
                _log.warning("merchant_buylists \u4fa1\u683c\u8a2d\u5b9a\u30df\u30b9 \u5e97:" + list.getListId() + " NPC:" + npcId + " " + npcName + " Item:" + tradeItem.getItemId() + " " + itemTemplate.getName() + " \u5e97\u982d\u4fa1\u683c:" + Util.formatAdena(buyPrice) + " \u58f2\u5374\u4fa1\u683c:" + Util.formatAdena(sellPrice));
                tradeItem.setPrice(10000000000L);
            }
        }
    }

    public L2TradeList getBuyList(int listId) {
        return this._lists.get(listId);
    }

    public List<L2TradeList> getBuyListByNpcId(int npcId) {
        FastList lists = new FastList();
        Collection<L2TradeList> values = this._lists.values();
        for (L2TradeList list : values) {
            String tradeNpcId = list.getNpcId();
            if (tradeNpcId.startsWith("gm") || npcId != Integer.parseInt(tradeNpcId)) continue;
            lists.add(list);
        }
        return lists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataCountStore() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE merchant_buylists SET currentCount=? WHERE item_id=? AND shop_id=?");
            for (L2TradeList list : this._lists.values()) {
                if (!list.hasLimitedStockItem()) continue;
                int listId = list.getListId();
                for (L2TradeList.L2TradeItem item : list.getItems()) {
                    long currentCount;
                    if (!item.hasLimitedStock() || (currentCount = item.getCurrentCount()) >= item.getMaxCount()) continue;
                    statement.setLong(1, currentCount);
                    statement.setInt(2, item.getItemId());
                    statement.setInt(3, listId);
                    statement.executeUpdate();
                    statement.clearParameters();
                }
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "TradeController: Could not store Count Item: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public synchronized int getNextId() {
        return this._nextListId++;
    }

    private static class SingletonHolder {
        protected static final TradeController _instance = new TradeController();

        private SingletonHolder() {
        }
    }
}

