/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver;

import com.l2jserver.Config;
import com.l2jserver.Server;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class L2DatabaseFactory {
    static Logger _log = Logger.getLogger(L2DatabaseFactory.class.getName());
    private static L2DatabaseFactory _instance;
    private static ScheduledExecutorService _executor;
    private ProviderType _providerType;
    private ComboPooledDataSource _source;

    public L2DatabaseFactory() throws SQLException {
        try {
            if (Config.DATABASE_MAX_CONNECTIONS < 2) {
                Config.DATABASE_MAX_CONNECTIONS = 2;
                _log.warning("A minimum of " + Config.DATABASE_MAX_CONNECTIONS + " db connections are required.");
            }
            this._source = new ComboPooledDataSource();
            this._source.setAutoCommitOnClose(true);
            this._source.setInitialPoolSize(10);
            this._source.setMinPoolSize(10);
            this._source.setMaxPoolSize(Math.max(10, Config.DATABASE_MAX_CONNECTIONS));
            this._source.setAcquireRetryAttempts(0);
            this._source.setAcquireRetryDelay(500);
            this._source.setCheckoutTimeout(0);
            this._source.setAcquireIncrement(5);
            this._source.setAutomaticTestTable("connection_test_table");
            this._source.setTestConnectionOnCheckin(false);
            this._source.setIdleConnectionTestPeriod(3600);
            this._source.setMaxIdleTime(Config.DATABASE_MAX_IDLE_TIME);
            this._source.setMaxStatementsPerConnection(100);
            this._source.setBreakAfterAcquireFailure(false);
            this._source.setDriverClass(Config.DATABASE_DRIVER);
            this._source.setJdbcUrl(Config.DATABASE_URL);
            this._source.setUser(Config.DATABASE_LOGIN);
            this._source.setPassword(Config.DATABASE_PASSWORD);
            this._source.getConnection().close();
            if (Config.DEBUG) {
                _log.fine("Database Connection Working");
            }
            this._providerType = Config.DATABASE_DRIVER.toLowerCase().contains("microsoft") ? ProviderType.MsSql : ProviderType.MySql;
        }
        catch (SQLException x) {
            if (Config.DEBUG) {
                _log.fine("Database Connection FAILED");
            }
            throw x;
        }
        catch (Exception e) {
            if (Config.DEBUG) {
                _log.fine("Database Connection FAILED");
            }
            throw new SQLException("Could not init DB connection:" + e.getMessage());
        }
    }

    public final String prepQuerySelect(String[] fields, String tableName, String whereClause, boolean returnOnlyTopRecord) {
        String msSqlTop1 = "";
        String mySqlTop1 = "";
        if (returnOnlyTopRecord) {
            if (this.getProviderType() == ProviderType.MsSql) {
                msSqlTop1 = " Top 1 ";
            }
            if (this.getProviderType() == ProviderType.MySql) {
                mySqlTop1 = " Limit 1 ";
            }
        }
        String query = "SELECT " + msSqlTop1 + this.safetyString(fields) + " FROM " + tableName + " WHERE " + whereClause + mySqlTop1;
        return query;
    }

    public void shutdown() {
        try {
            this._source.close();
        }
        catch (Exception e) {
            _log.log(Level.INFO, "", e);
        }
        try {
            this._source = null;
        }
        catch (Exception e) {
            _log.log(Level.INFO, "", e);
        }
    }

    public final String safetyString(String ... whatToCheck) {
        char braceRight;
        char braceLeft;
        if (this.getProviderType() == ProviderType.MsSql) {
            braceLeft = '[';
            braceRight = ']';
        } else {
            braceLeft = '`';
            braceRight = '`';
        }
        int length = 0;
        for (String word : whatToCheck) {
            length += word.length() + 4;
        }
        StringBuilder sbResult = new StringBuilder(length);
        for (String word : whatToCheck) {
            if (sbResult.length() > 0) {
                sbResult.append(", ");
            }
            sbResult.append(braceLeft);
            sbResult.append(word);
            sbResult.append(braceRight);
        }
        return sbResult.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static L2DatabaseFactory getInstance() throws SQLException {
        Class<L2DatabaseFactory> clazz = L2DatabaseFactory.class;
        synchronized (L2DatabaseFactory.class) {
            if (_instance == null) {
                _instance = new L2DatabaseFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public Connection getConnection() {
        Connection con = null;
        while (con == null) {
            try {
                con = this._source.getConnection();
                if (Server.serverMode == 1) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new ConnectionCloser(con, new RuntimeException()), Config.CONNECTION_CLOSE_TIME);
                    continue;
                }
                L2DatabaseFactory.getExecutor().schedule(new ConnectionCloser(con, new RuntimeException()), 60L, TimeUnit.SECONDS);
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "L2DatabaseFactory: getConnection() failed, trying again " + e.getMessage(), e);
            }
        }
        return con;
    }

    public static void close(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Failed to close database connection!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledExecutorService getExecutor() {
        if (_executor != null) return _executor;
        Class<L2DatabaseFactory> clazz = L2DatabaseFactory.class;
        synchronized (L2DatabaseFactory.class) {
            if (_executor != null) return _executor;
            _executor = Executors.newSingleThreadScheduledExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _executor;
        }
    }

    public int getBusyConnectionCount() throws SQLException {
        return this._source.getNumBusyConnectionsDefaultUser();
    }

    public int getIdleConnectionCount() throws SQLException {
        return this._source.getNumIdleConnectionsDefaultUser();
    }

    public final ProviderType getProviderType() {
        return this._providerType;
    }

    private static class ConnectionCloser
    implements Runnable {
        private final Connection c;
        private final RuntimeException exp;

        public ConnectionCloser(Connection con, RuntimeException e) {
            this.c = con;
            this.exp = e;
        }

        @Override
        public void run() {
            try {
                if (!this.c.isClosed()) {
                    _log.log(Level.WARNING, "Unclosed connection! Trace: " + this.exp.getStackTrace()[1], this.exp);
                }
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public static enum ProviderType {
        MySql,
        MsSql;

    }
}

