/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller.util.mysql;

import com.l2jserver.tools.dbinstaller.DBOutputInterface;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class ScriptExecutor {
    DBOutputInterface _frame;

    public ScriptExecutor(DBOutputInterface frame) {
        this._frame = frame;
    }

    public void execSqlBatch(File dir) {
        this.execSqlBatch(dir, false);
    }

    public void execSqlBatch(File dir, boolean skipErrors) {
        File[] file = dir.listFiles(new SqlFileFilter());
        this._frame.setProgressIndeterminate(false);
        this._frame.setProgressMaximum(file.length - 1);
        for (int i = 0; i < file.length; ++i) {
            this._frame.setProgressValue(i);
            this.execSqlFile(file[i], skipErrors);
        }
    }

    public void execSqlFile(File file) {
        this.execSqlFile(file, false);
    }

    public void execSqlFile(File file, boolean skipErrors) {
        block6: {
            try {
                this._frame.appendToProgressArea("Installing " + file.getName());
                String line = "";
                Connection con = this._frame.getConnection();
                Statement stmt = con.createStatement();
                Scanner scn = new Scanner(file);
                StringBuilder sb = new StringBuilder(256);
                while (scn.hasNextLine()) {
                    line = scn.nextLine();
                    if (line.startsWith("--")) continue;
                    if (line.contains("--")) {
                        line = line.split("--")[0];
                    }
                    if (!(line = line.trim()).isEmpty()) {
                        sb.append(line).append('\n');
                    }
                    if (!line.endsWith(";")) continue;
                    stmt.execute(sb.toString());
                    sb = new StringBuilder(256);
                }
                scn.close();
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(null, "File Not Found!: " + e.getMessage(), "Installer Error", 0);
            }
            catch (SQLException e) {
                if (skipErrors) break block6;
                Object[] options = new Object[]{"Continue", "Abort"};
                int n = JOptionPane.showOptionDialog(null, "MySQL Error: " + e.getMessage(), "Script Error", 0, 2, null, options, options[0]);
                if (n != 1) break block6;
                System.exit(0);
            }
        }
    }

    public static class SqlFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".sql");
        }
    }
}

