/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller.gui;

import com.l2jserver.tools.dbinstaller.DBOutputInterface;
import com.l2jserver.tools.images.ImagesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.sql.Connection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DBInstallerGUI
extends JFrame
implements DBOutputInterface {
    private static final long serialVersionUID = -1005504757826370170L;
    private JProgressBar _progBar;
    private JTextArea _progArea;
    private Connection _con;

    public DBInstallerGUI(Connection con) {
        super("L2J Database Installer");
        this.setLayout(new BorderLayout());
        DBInstallerGUI.setDefaultLookAndFeelDecorated(true);
        this.setIconImage(ImagesTable.getImage("l2j.png").getImage());
        this._con = con;
        int width = 480;
        int height = 360;
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        this.setDefaultCloseOperation(3);
        this.setBounds((resolution.width - width) / 2, (resolution.height - height) / 2, width, height);
        this.setResizable(false);
        this._progBar = new JProgressBar();
        this._progBar.setIndeterminate(true);
        this.add((Component)this._progBar, "First");
        this._progArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this._progArea);
        this._progArea.setEditable(false);
        this.appendToProgressArea("Connected");
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void setProgressIndeterminate(boolean value) {
        this._progBar.setIndeterminate(value);
    }

    @Override
    public void setProgressMaximum(int maxValue) {
        this._progBar.setMaximum(maxValue);
    }

    @Override
    public void setProgressValue(int value) {
        this._progBar.setValue(value);
    }

    @Override
    public void appendToProgressArea(String text) {
        this._progArea.append(text + "\n");
        this._progArea.setCaretPosition(this._progArea.getDocument().getLength());
    }

    @Override
    public Connection getConnection() {
        return this._con;
    }

    @Override
    public void setFrameVisible(boolean value) {
        this.setVisible(value);
    }

    @Override
    public int requestConfirm(String title, String message, int type) {
        return JOptionPane.showConfirmDialog(null, message, title, type);
    }

    @Override
    public void showMessage(String title, String message, int type) {
        JOptionPane.showMessageDialog(null, message, title, type);
    }
}

