/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller;

import com.l2jserver.tools.dbinstaller.DBOutputInterface;
import com.l2jserver.tools.dbinstaller.util.mysql.DBDumper;
import com.l2jserver.tools.dbinstaller.util.mysql.ScriptExecutor;
import java.io.File;
import java.sql.SQLException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class RunTasks
extends Thread {
    DBOutputInterface _frame;
    boolean _cleanInstall;
    String _db;
    String _sqlDir;
    String _cleanUpFile;

    public RunTasks(DBOutputInterface frame, String db, String sqlDir, String cleanUpFile, boolean cleanInstall) {
        this._frame = frame;
        this._db = db;
        this._cleanInstall = cleanInstall;
        this._sqlDir = sqlDir;
        this._cleanUpFile = cleanUpFile;
    }

    @Override
    public void run() {
        int ch;
        File modDir;
        int ch2;
        new DBDumper(this._frame, this._db);
        ScriptExecutor exec = new ScriptExecutor(this._frame);
        File clnFile = new File(this._cleanUpFile);
        File updDir = new File(this._sqlDir, "updates");
        File[] files = updDir.listFiles(new ScriptExecutor.SqlFileFilter());
        Preferences prefs = Preferences.userRoot();
        if (this._cleanInstall) {
            if (clnFile.exists()) {
                this._frame.appendToProgressArea("Cleaning Database...");
                exec.execSqlFile(clnFile);
                this._frame.appendToProgressArea("Database Cleaned!");
            } else {
                this._frame.appendToProgressArea("Database Cleaning Script Not Found!");
            }
            if (updDir.exists()) {
                StringBuilder sb = new StringBuilder(256);
                for (File cf : files) {
                    sb.append(cf.getName() + ';');
                }
                prefs.put(this._db + "_upd", sb.toString());
            }
        } else if (!this._cleanInstall && updDir.exists()) {
            this._frame.appendToProgressArea("Installing Updates...");
            for (File cf : files) {
                if (prefs.get(this._db + "_upd", "").contains(cf.getName())) continue;
                exec.execSqlFile(cf, true);
                prefs.put(this._db + "_upd", prefs.get(this._db + "_upd", "") + cf.getName() + ";");
            }
            this._frame.appendToProgressArea("Database Updates Installed!");
        }
        this._frame.appendToProgressArea("Installing Database Content...");
        exec.execSqlBatch(new File(this._sqlDir));
        this._frame.appendToProgressArea("Database Installation Complete!");
        File cusDir = new File(this._sqlDir, "custom");
        if (cusDir.exists() && (ch2 = this._frame.requestConfirm("Install Custom", "Do you want to install custom tables?", 0)) == 0) {
            this._frame.appendToProgressArea("Installing Custom Tables...");
            exec.execSqlBatch(cusDir);
            this._frame.appendToProgressArea("Custom Tables Installed!");
        }
        if ((modDir = new File(this._sqlDir, "mods")).exists() && (ch = this._frame.requestConfirm("Install Mods", "Do you want to install mod tables?", 0)) == 0) {
            this._frame.appendToProgressArea("Installing Mods Tables...");
            exec.execSqlBatch(modDir);
            this._frame.appendToProgressArea("Mods Tables Installed!");
        }
        try {
            this._frame.getConnection().close();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Cannot close MySQL Connection: " + e.getMessage(), "Connection Error", 0);
        }
        this._frame.setFrameVisible(false);
        this._frame.showMessage("Done!", "Database Installation Complete!", 1);
        System.exit(0);
    }
}

