/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

/**
 * This class handles following admin commands:
 *   <li> hp Edit HP
 */
public class AdminHP implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_hp",
	};
	
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		String[] args = command.split(" +", 2);
		
		if (args[0].equals("admin_hp"))
		{
			try
			{
				L2Object obj = activeChar.getTarget();
				if (!(obj instanceof L2Character))
				{
					activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET));
					throw new IllegalStateException();
				}
				L2Character target = (L2Character) obj;
				
				String arg1 = args[1];
				final boolean flag = arg1.charAt(0) == '+' || arg1.charAt(0) == '-';
				final boolean parcent;
				if (arg1.charAt(arg1.length() - 1) == '%')
				{
					arg1 = arg1.substring(0, arg1.length() - 1);
					parcent = true;
				}
				else
				{
					parcent = false;
				}
				final double value = Double.valueOf(arg1);
				
				double newHp;
				if (parcent)
					newHp = target.getMaxHp() * value / 100.0;
				else
					newHp = value;
				if (flag)
					newHp += target.getCurrentHp();
				if (newHp < 0.0)
					newHp = 0.0;
				target.setCurrentHp(newHp);
			}
			catch (Exception e)
			{
				activeChar.sendMessage("Usage: //hp [+|-]HP[%]");
				//Thread.dumpStack();
			}
		}
		return true;
	}
	
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
}
