/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

import java.nio.ByteBuffer;
import org.mmocore.network.AbstractPacket;
import org.mmocore.network.MMOClient;
import org.mmocore.network.NioNetStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReceivablePacket<T extends MMOClient<?>>
extends AbstractPacket<T>
implements Runnable {
    NioNetStringBuffer _sbuf;

    protected ReceivablePacket() {
    }

    protected abstract boolean read();

    @Override
    public abstract void run();

    protected final void readB(byte[] dst) {
        this._buf.get(dst);
    }

    protected final void readB(byte[] dst, int offset, int len) {
        this._buf.get(dst, offset, len);
    }

    protected final int readC() {
        return this._buf.get() & 0xFF;
    }

    protected final int readH() {
        return this._buf.getShort() & 0xFFFF;
    }

    protected final int readD() {
        return this._buf.getInt();
    }

    protected final long readQ() {
        return this._buf.getLong();
    }

    protected final double readF() {
        return this._buf.getDouble();
    }

    protected final String readS() {
        char ch;
        this._sbuf.clear();
        while ((ch = this._buf.getChar()) != '\u0000') {
            this._sbuf.append(ch);
        }
        return this._sbuf.toString();
    }

    public void setBuffers(ByteBuffer data, T client, NioNetStringBuffer sBuffer) {
        this._buf = data;
        this._client = client;
        this._sbuf = sBuffer;
    }
}

