/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.PyType;

public abstract class PySequence
extends PyObject {
    public PySequence() {
    }

    protected PySequence(PyType pyType) {
        super(pyType);
    }

    protected abstract PyObject pyget(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void set(int n, PyObject pyObject) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void del(int n) throws PyException {
        throw Py.TypeError("can't remove from immutable object");
    }

    protected void delRange(int n, int n2, int n3) {
        throw Py.TypeError("can't remove from immutable object");
    }

    public boolean __nonzero__() {
        return this.seq___nonzero__();
    }

    final boolean seq___nonzero__() {
        return this.__len__() != 0;
    }

    public PyObject __iter__() {
        return this.seq___iter__();
    }

    final PyObject seq___iter__() {
        return new PySequenceIter(this);
    }

    public synchronized PyObject __eq__(PyObject pyObject) {
        return this.seq___eq__(pyObject);
    }

    final synchronized PyObject seq___eq__(PyObject pyObject) {
        int n;
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.Zero;
        }
        int n3 = PySequence.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.One : Py.Zero;
    }

    public synchronized PyObject __ne__(PyObject pyObject) {
        return this.seq___ne__(pyObject);
    }

    final synchronized PyObject seq___ne__(PyObject pyObject) {
        int n;
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.One;
        }
        int n3 = PySequence.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.Zero : Py.One;
    }

    public synchronized PyObject __lt__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._lt(pyObject.__finditem__(n));
    }

    final synchronized PyObject seq___lt__(PyObject pyObject) {
        return this.__lt__(pyObject);
    }

    public synchronized PyObject __le__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 || n == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._le(pyObject.__finditem__(n));
    }

    final synchronized PyObject seq___le__(PyObject pyObject) {
        return this.__le__(pyObject);
    }

    public synchronized PyObject __gt__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._gt(pyObject.__finditem__(n));
    }

    final synchronized PyObject seq___gt__(PyObject pyObject) {
        return this.__gt__(pyObject);
    }

    public synchronized PyObject __ge__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 || n == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._ge(pyObject.__finditem__(n));
    }

    final synchronized PyObject seq___ge__(PyObject pyObject) {
        return this.__ge__(pyObject);
    }

    protected static int cmp(PyObject pyObject, int n, PyObject pyObject2, int n2) {
        if (n < 0) {
            n = pyObject.__len__();
        }
        if (n2 < 0) {
            n2 = pyObject2.__len__();
        }
        for (int i = 0; i < n && i < n2; ++i) {
            if (pyObject.__getitem__(i)._eq(pyObject2.__getitem__(i)).__nonzero__()) continue;
            return i;
        }
        if (n == n2) {
            return -2;
        }
        return n < n2 ? -1 : -3;
    }

    protected static PyObject fastSequence(PyObject pyObject, String string) {
        if (pyObject instanceof PyList || pyObject instanceof PyTuple) {
            return pyObject;
        }
        PyList pyList = new PyList();
        PyObject pyObject2 = Py.iter(pyObject, string);
        PyObject pyObject3 = null;
        while ((pyObject3 = pyObject2.__iternext__()) != null) {
            pyList.append(pyObject3);
        }
        return pyList;
    }

    protected static final int sliceLength(int n, int n2, int n3) {
        int n4 = n3 > 0 ? (n2 - n + n3 - 1) / n3 : (n2 - n + n3 + 1) / n3;
        if (n4 < 0) {
            return 0;
        }
        return n4;
    }

    private static final int getIndex(PyObject pyObject, int n) {
        block6: {
            if (pyObject == Py.None || pyObject == null) {
                return n;
            }
            if (pyObject instanceof PyLong) {
                try {
                    pyObject = (PyInteger)pyObject.__int__();
                }
                catch (PyException pyException) {
                    if (!Py.matchException(pyException, Py.OverflowError)) break block6;
                    if (new PyLong(0L).__cmp__(pyObject) < 0) {
                        return Integer.MAX_VALUE;
                    }
                    return 0;
                }
            }
        }
        if (!(pyObject instanceof PyInteger)) {
            throw Py.TypeError("slice index must be int");
        }
        return ((PyInteger)pyObject).getValue();
    }

    protected int fixindex(int n) {
        int n2 = this.__len__();
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        return n;
    }

    public synchronized PyObject __finditem__(int n) {
        if ((n = this.fixindex(n)) == -1) {
            return null;
        }
        return this.pyget(n);
    }

    public PyObject __finditem__(PyObject pyObject) {
        return this.seq___finditem__(pyObject);
    }

    final PyObject seq___finditem__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return this.__finditem__(((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PySlice) {
            PySlice pySlice = (PySlice)pyObject;
            return this.__getslice__(pySlice.start, pySlice.stop, pySlice.step);
        }
        if (pyObject instanceof PyLong) {
            return this.__finditem__(((PyInteger)pyObject.__int__()).getValue());
        }
        throw Py.TypeError("sequence subscript must be integer or slice");
    }

    public PyObject __getitem__(PyObject pyObject) {
        return this.seq___getitem__(pyObject);
    }

    final PyObject seq___getitem__(PyObject pyObject) {
        PyObject pyObject2 = this.__finditem__(pyObject);
        if (pyObject2 == null) {
            throw Py.IndexError("index out of range: " + pyObject);
        }
        return pyObject2;
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isNumberType() throws PyIgnoreMethodTag {
        return false;
    }

    protected static final int getStep(PyObject pyObject) {
        int n = PySequence.getIndex(pyObject, 1);
        if (n == 0) {
            throw Py.TypeError("slice step of zero not allowed");
        }
        return n;
    }

    protected static final int getStart(PyObject pyObject, int n, int n2) {
        int n3;
        if (n < 0) {
            n3 = PySequence.getIndex(pyObject, n2 - 1);
            if (n3 < 0) {
                n3 += n2;
            }
            if (n3 < 0) {
                n3 = -1;
            }
            if (n3 >= n2) {
                n3 = n2 - 1;
            }
        } else {
            n3 = PySequence.getIndex(pyObject, 0);
            if (n3 < 0) {
                n3 += n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 >= n2) {
                n3 = n2;
            }
        }
        return n3;
    }

    protected static final int getStop(PyObject pyObject, int n, int n2, int n3) {
        int n4;
        if (n2 < 0) {
            n4 = PySequence.getIndex(pyObject, -1);
            if (n4 < -1) {
                n4 = n3 + n4;
            }
            if (n4 < -1) {
                n4 = -1;
            }
        } else {
            n4 = PySequence.getIndex(pyObject, n3);
            if (n4 < 0) {
                n4 = n3 + n4;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        if (n4 > n3) {
            n4 = n3;
        }
        return n4;
    }

    public synchronized PyObject __getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return this.seq___getslice__(pyObject, pyObject2, pyObject3);
    }

    final synchronized PyObject seq___getslice__(PyObject pyObject, PyObject pyObject2) {
        return this.seq___getslice__(pyObject, pyObject2, null);
    }

    final synchronized PyObject seq___getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n = this.__len__();
        int n2 = PySequence.getStep(pyObject3);
        int n3 = PySequence.getStart(pyObject, n2, n);
        int n4 = PySequence.getStop(pyObject2, n3, n2, n);
        return this.getslice(n3, n4, n2);
    }

    public synchronized void __setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        this.seq___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
    }

    final synchronized void seq___setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        this.seq___setslice__(pyObject, pyObject2, null, pyObject3);
    }

    final synchronized void seq___setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        int n = this.__len__();
        int n2 = PySequence.getStep(pyObject3);
        int n3 = PySequence.getStart(pyObject, n2, n);
        int n4 = PySequence.getStop(pyObject2, n3, n2, n);
        this.setslice(n3, n4, n2, pyObject4);
    }

    public synchronized void __delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        this.seq___delslice__(pyObject, pyObject2, pyObject3);
    }

    final synchronized void seq___delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n = this.__len__();
        int n2 = PySequence.getStep(pyObject3);
        int n3 = PySequence.getStart(pyObject, n2, n);
        int n4 = PySequence.getStop(pyObject2, n3, n2, n);
        this.delRange(n3, n4, n2);
    }

    public synchronized void __setitem__(int n, PyObject pyObject) {
        int n2 = this.fixindex(n);
        if (n2 == -1) {
            throw Py.IndexError("index out of range: " + n2);
        }
        this.set(n2, pyObject);
    }

    public void __setitem__(PyObject pyObject, PyObject pyObject2) {
        this.seq___setitem__(pyObject, pyObject2);
    }

    final void seq___setitem__(PyObject pyObject, PyObject pyObject2) {
        if (pyObject instanceof PyInteger) {
            this.__setitem__(((PyInteger)pyObject).getValue(), pyObject2);
        } else if (pyObject instanceof PySlice) {
            PySlice pySlice = (PySlice)pyObject;
            this.__setslice__(pySlice.start, pySlice.stop, pySlice.step, pyObject2);
        } else if (pyObject instanceof PyLong) {
            this.__setitem__(((PyInteger)pyObject.__int__()).getValue(), pyObject2);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    public synchronized void __delitem__(PyObject pyObject) {
        this.seq___delitem__(pyObject);
    }

    final synchronized void seq___delitem__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            int n = this.fixindex(((PyInteger)pyObject).getValue());
            if (n == -1) {
                throw Py.IndexError("index out of range: " + n);
            }
            this.del(n);
        } else if (pyObject instanceof PySlice) {
            PySlice pySlice = (PySlice)pyObject;
            this.__delslice__(pySlice.start, pySlice.stop, pySlice.step);
        } else if (pyObject instanceof PyLong) {
            int n = this.fixindex(((PyInteger)pyObject.__int__()).getValue());
            if (n == -1) {
                throw Py.IndexError("index out of range: " + n);
            }
            this.del(n);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    public synchronized Object __tojava__(Class clazz) throws PyIgnoreMethodTag {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            try {
                int n = this.__len__();
                PyArray pyArray = new PyArray(clazz2, n);
                for (int i = 0; i < n; ++i) {
                    PyObject pyObject = this.pyget(i);
                    pyArray.set(i, pyObject);
                }
                return pyArray.getArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(clazz);
    }
}

