/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.pipe.csv;

import com.ziclix.python.sql.pipe.Sink;
import com.ziclix.python.sql.pipe.csv.CSVString;
import java.io.PrintWriter;
import org.python.core.Py;
import org.python.core.PyObject;

public class CSVSink
implements Sink {
    protected boolean header = false;
    protected String delimiter;
    protected PrintWriter writer;
    protected PyObject converters;

    public CSVSink(PrintWriter printWriter) {
        this(printWriter, Py.None);
    }

    public CSVSink(PrintWriter printWriter, PyObject pyObject) {
        this.writer = printWriter;
        this.converters = pyObject;
        this.delimiter = ",";
    }

    public void row(PyObject pyObject) {
        String[] stringArray = new String[pyObject.__len__()];
        if (this.header) {
            for (int i = 0; i < pyObject.__len__(); ++i) {
                stringArray[i] = this.convert(Py.newInteger(i), pyObject.__getitem__(i));
            }
        } else {
            for (int i = 0; i < pyObject.__len__(); ++i) {
                stringArray[i] = pyObject.__getitem__(i).__getitem__(0).toString();
            }
            this.header = true;
        }
        this.println(stringArray);
    }

    protected String convert(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3;
        if (this.converters != Py.None && (pyObject3 = this.converters.__finditem__(pyObject)) != Py.None) {
            pyObject2 = pyObject3.__call__(pyObject2);
        }
        if (pyObject2 == Py.None || pyObject2 == null) {
            return "";
        }
        return CSVString.toCSV(pyObject2.toString());
    }

    protected void println(String[] stringArray) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            this.writer.print(stringArray[i]);
            this.writer.print(this.delimiter);
        }
        this.writer.println(stringArray[stringArray.length - 1]);
    }

    public void start() {
    }

    public void end() {
    }
}

