/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.db.sql;

import com.mchange.io.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource,
Serializable,
Referenceable {
    static final String REF_FACTORY_NAME = DmdsObjectFactory.class.getName();
    static final String REF_JDBC_URL = "jdbcUrl";
    static final String REF_DFLT_USER = "dfltUser";
    static final String REF_DFLT_PWD = "dfltPassword";
    String jdbcUrl;
    String dfltUser;
    String dfltPassword;
    static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v1$db$sql$DriverManagerDataSource;

    public DriverManagerDataSource(String jdbcUrl, String dfltUser, String dfltPassword) {
        this.jdbcUrl = jdbcUrl;
        this.dfltUser = dfltUser;
        this.dfltPassword = dfltPassword;
    }

    public DriverManagerDataSource(String jdbcUrl) {
        this(jdbcUrl, null, null);
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.createProps(null, null));
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.createProps(username, password));
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    public Reference getReference() throws NamingException {
        Reference out = new Reference(this.getClass().getName(), REF_FACTORY_NAME, null);
        out.add(new StringRefAddr(REF_JDBC_URL, this.jdbcUrl));
        out.add(new StringRefAddr(REF_DFLT_USER, this.dfltUser));
        out.add(new StringRefAddr(REF_DFLT_PWD, this.dfltPassword));
        return out;
    }

    private Properties createProps(String user, String password) {
        Properties props = new Properties();
        if (user != null) {
            props.put("user", user);
            props.put("password", password);
        } else if (this.dfltUser != null) {
            props.put("user", this.dfltUser);
            props.put("password", this.dfltPassword);
        }
        return props;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.jdbcUrl);
        out.writeUTF(this.dfltUser);
        out.writeUTF(this.dfltPassword);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        short version = in.readShort();
        switch (version) {
            case 1: {
                this.jdbcUrl = in.readUTF();
                this.dfltUser = in.readUTF();
                this.dfltPassword = in.readUTF();
                break;
            }
            default: {
                throw new UnsupportedVersionException(this, version);
            }
        }
    }

    public static class DmdsObjectFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
            Reference ref;
            String className = (class$com$mchange$v1$db$sql$DriverManagerDataSource == null ? (class$com$mchange$v1$db$sql$DriverManagerDataSource = DriverManagerDataSource.class$("com.mchange.v1.db.sql.DriverManagerDataSource")) : class$com$mchange$v1$db$sql$DriverManagerDataSource).getName();
            if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(className)) {
                return new DriverManagerDataSource((String)ref.get(DriverManagerDataSource.REF_JDBC_URL).getContent(), (String)ref.get(DriverManagerDataSource.REF_DFLT_USER).getContent(), (String)ref.get(DriverManagerDataSource.REF_DFLT_PWD).getContent());
            }
            return null;
        }
    }
}

