/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.conditions;

import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;

public class ConditionPetType
extends Condition {
    private int petType;

    public ConditionPetType(int petType) {
        this.petType = petType;
    }

    @Override
    boolean testImpl(Env env) {
        if (!(env.player instanceof L2PetInstance)) {
            return false;
        }
        int npcid = ((L2Summon)env.player).getNpcId();
        if (PetDataTable.isHatchling(npcid) && (this.petType & 2) == 2) {
            return true;
        }
        if (PetDataTable.isWolf(npcid) && (this.petType & 1) == 1) {
            return true;
        }
        if (PetDataTable.isEvolvedWolf(npcid) && (this.petType & 0x20) == 32) {
            return true;
        }
        if (PetDataTable.isStrider(npcid) && (this.petType & 4) == 4) {
            return true;
        }
        if (PetDataTable.isBaby(npcid) && (this.petType & 8) == 8) {
            return true;
        }
        return PetDataTable.isImprovedBaby(npcid) && (this.petType & 0x10) == 16;
    }
}

