/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import com.l2jserver.Config;
import com.l2jserver.gameserver.scripting.CompiledScriptHolder;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javolution.util.FastMap;

public class CompiledScriptCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(CompiledScriptCache.class.getName());
    private Map<String, CompiledScriptHolder> _compiledScriptCache = new FastMap();
    private transient boolean _modified = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript loadCompiledScript(ScriptEngine engine, File file) throws FileNotFoundException, ScriptException {
        BufferedReader reader;
        Compilable eng;
        CompiledScript cs;
        int len = L2ScriptEngineManager.SCRIPT_FOLDER.getPath().length() + 1;
        String relativeName = file.getPath().substring(len);
        CompiledScriptHolder csh = this._compiledScriptCache.get(relativeName);
        if (csh != null && csh.matches(file)) {
            if (Config.DEBUG) {
                LOG.fine("Reusing cached compiled script: " + file);
            }
            return csh.getCompiledScript();
        }
        if (Config.DEBUG) {
            LOG.info("Compiling script: " + file);
        }
        if ((cs = (eng = (Compilable)((Object)engine)).compile(reader = new BufferedReader(new InputStreamReader(new FileInputStream(file))))) instanceof Serializable) {
            Map<String, CompiledScriptHolder> map = this._compiledScriptCache;
            synchronized (map) {
                this._compiledScriptCache.put(relativeName, new CompiledScriptHolder(cs, file));
                this._modified = true;
            }
        }
        return cs;
    }

    public boolean isModified() {
        return this._modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Map<String, CompiledScriptHolder> map = this._compiledScriptCache;
        synchronized (map) {
            for (String path : this._compiledScriptCache.keySet()) {
                File file = new File(L2ScriptEngineManager.SCRIPT_FOLDER, path);
                if (file.isFile()) continue;
                this._compiledScriptCache.remove(path);
                this._modified = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws FileNotFoundException, IOException {
        Map<String, CompiledScriptHolder> map = this._compiledScriptCache;
        synchronized (map) {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(L2ScriptEngineManager.SCRIPT_FOLDER, "CompiledScripts.cache")));
            oos.writeObject(this);
            this._modified = false;
        }
    }
}

