/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class GMViewItemList
extends L2GameServerPacket {
    private static final String _S__AD_GMVIEWITEMLIST = "[S] 9a GMViewItemList";
    private L2ItemInstance[] _items;
    private int _limit;
    private String _playerName;

    public GMViewItemList(L2PcInstance cha) {
        this._items = cha.getInventory().getItems();
        this._playerName = cha.getName();
        this._limit = cha.getInventoryLimit();
    }

    public GMViewItemList(L2PetInstance cha) {
        this._items = cha.getInventory().getItems();
        this._playerName = cha.getName();
        this._limit = cha.getInventoryLimit();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(154);
        this.writeS(this._playerName);
        this.writeD(this._limit);
        this.writeH(1);
        this.writeH(this._items.length);
        for (L2ItemInstance temp : this._items) {
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getLocationSlot());
            this.writeQ(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(temp.getCustomType1());
            this.writeH(temp.isEquipped() ? 1 : 0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(temp.getCustomType2());
            if (temp.isAugmented()) {
                this.writeD(temp.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(temp.getMana());
            this.writeD(temp.isTimeLimitedItem() ? (int)(temp.getRemainingTime() / 1000L) : -9999);
            this.writeH(temp.getAttackElementType());
            this.writeH(temp.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(temp.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__AD_GMVIEWITEMLIST;
    }
}

