/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Macro;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestMakeMacro
extends L2GameClientPacket {
    protected static final Logger _log = Logger.getLogger(RequestMakeMacro.class.getName());
    private L2Macro _macro;
    private int _commandsLenght = 0;
    private static final String _C__C1_REQUESTMAKEMACRO = "[C] C1 RequestMakeMacro";
    private static final int MAX_MACRO_LENGTH = 12;

    @Override
    protected void readImpl() {
        int _id = this.readD();
        String _name = this.readS();
        String _desc = this.readS();
        String _acronym = this.readS();
        int _icon = this.readC();
        int _count = this.readC();
        if (_count > 12) {
            _count = 12;
        }
        L2Macro.L2MacroCmd[] commands = new L2Macro.L2MacroCmd[_count];
        if (Config.DEBUG) {
            _log.info("Make macro id:" + _id + "\tname:" + _name + "\tdesc:" + _desc + "\tacronym:" + _acronym + "\ticon:" + _icon + "\tcount:" + _count);
        }
        for (int i = 0; i < _count; ++i) {
            int entry = this.readC();
            int type = this.readC();
            int d1 = this.readD();
            int d2 = this.readC();
            String command = this.readS();
            this._commandsLenght += command.length();
            commands[i] = new L2Macro.L2MacroCmd(entry, type, d1, d2, command);
            if (!Config.DEBUG) continue;
            _log.info("entry:" + entry + "\ttype:" + type + "\td1:" + d1 + "\td2:" + d2 + "\tcommand:" + command);
        }
        this._macro = new L2Macro(_id, _icon, _name, _desc, _acronym, commands);
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._commandsLenght > 255) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INVALID_MACRO));
            return;
        }
        if (player.getMacroses().getAllMacroses().length > 48) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_MAY_CREATE_UP_TO_48_MACROS));
            return;
        }
        if (this._macro.name.length() == 0) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ENTER_THE_MACRO_NAME));
            return;
        }
        if (this._macro.descr.length() > 32) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.MACRO_DESCRIPTION_MAX_32_CHARS));
            return;
        }
        player.registerMacro(this._macro);
    }

    @Override
    public String getType() {
        return _C__C1_REQUESTMAKEMACRO;
    }
}

