/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AskJoinPledge;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestJoinPledge
extends L2GameClientPacket {
    private static final String _C__24_REQUESTJOINPLEDGE = "[C] 24 RequestJoinPledge";
    private int _target;
    private int _pledgeType;

    @Override
    protected void readImpl() {
        this._target = this.readD();
        this._pledgeType = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        L2PcInstance target = L2World.getInstance().getPlayer(this._target);
        if (target == null) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET));
            return;
        }
        if (!clan.checkClanJoinCondition(activeChar, target, this._pledgeType)) {
            return;
        }
        if (!activeChar.getRequest().setRequest(target, this)) {
            return;
        }
        String pledgeName = activeChar.getClan().getName();
        String subPledgeName = activeChar.getClan().getSubPledge(this._pledgeType) != null ? activeChar.getClan().getSubPledge(this._pledgeType).getName() : null;
        target.sendPacket(new AskJoinPledge(activeChar.getObjectId(), subPledgeName, this._pledgeType, pledgeName));
    }

    public int getPledgeType() {
        return this._pledgeType;
    }

    @Override
    public String getType() {
        return _C__24_REQUESTJOINPLEDGE;
    }
}

