/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellListPacket;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.logging.Logger;

public final class RequestBuyItem
extends L2GameClientPacket {
    private static final String _C__1F_REQUESTBUYITEM = "[C] 1F RequestBuyItem";
    private static Logger _log = Logger.getLogger(RequestBuyItem.class.getName());
    private static final int BATCH_LENGTH = 12;
    private int _listId;
    private Item[] _items = null;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new Item[count];
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long cnt = this.readQ();
            if (itemId < 1 || cnt < 1L) {
                this._items = null;
                return;
            }
            this._items[i] = new Item(itemId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("buy")) {
            player.sendMessage("You buying too fast.");
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && player.getKarma() > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object target = player.getTarget();
        L2Character merchant = null;
        if (!player.isGM()) {
            if (target == null || !player.isInsideRadius(target, 150, true, false) || player.getInstanceId() != target.getInstanceId()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target instanceof L2MerchantInstance || target instanceof L2MerchantSummonInstance) {
                merchant = (L2Character)target;
            } else {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        L2TradeList list = null;
        double castleTaxRate = 0.0;
        double baseTaxRate = 0.0;
        if (merchant != null) {
            List<L2TradeList> lists;
            if (merchant instanceof L2MerchantInstance) {
                lists = TradeController.getInstance().getBuyListByNpcId(((L2MerchantInstance)merchant).getNpcId());
                castleTaxRate = ((L2MerchantInstance)merchant).getMpc().getCastleTaxRate();
                baseTaxRate = ((L2MerchantInstance)merchant).getMpc().getBaseTaxRate();
            } else {
                lists = TradeController.getInstance().getBuyListByNpcId(((L2MerchantSummonInstance)merchant).getNpcId());
                baseTaxRate = 50.0;
            }
            if (!player.isGM()) {
                if (lists == null) {
                    Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
                    return;
                }
                for (L2TradeList tradeList : lists) {
                    if (tradeList.getListId() != this._listId) continue;
                    list = tradeList;
                }
            } else {
                list = TradeController.getInstance().getBuyList(this._listId);
            }
        } else {
            list = TradeController.getInstance().getBuyList(this._listId);
        }
        if (list == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        this._listId = list.getListId();
        long subTotal = 0L;
        long slots = 0L;
        long weight = 0L;
        for (Item i : this._items) {
            long price = -1L;
            L2TradeList.L2TradeItem tradeItem = list.getItemById(i.getItemId());
            if (tradeItem == null) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + i.getItemId(), Config.DEFAULT_PUNISH);
                return;
            }
            L2Item template = ItemTable.getInstance().getTemplate(i.getItemId());
            if (template == null) continue;
            if (!template.isStackable() && i.getCount() > 1L) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase invalid quantity of items at the same time.", Config.DEFAULT_PUNISH);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED);
                this.sendPacket(sm);
                sm = null;
                return;
            }
            price = list.getPriceForItemId(i.getItemId());
            if (i.getItemId() >= 3960 && i.getItemId() <= 4026) {
                price = (long)((float)price * Config.RATE_SIEGE_GUARDS_PRICE);
            }
            if (price < 0L) {
                _log.warning("ERROR, no price found .. wrong buylist ??");
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (price == 0L && !player.isGM() && Config.ONLY_GM_ITEMS_FREE) {
                player.sendMessage("Ohh Cheat dont work? You have a problem now!");
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried buy item for 0 adena.", Config.DEFAULT_PUNISH);
                return;
            }
            if (tradeItem.hasLimitedStock() && i.getCount() > tradeItem.getCurrentCount()) {
                return;
            }
            if (99900000000L / i.getCount() < price) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + 99900000000L + " adena worth of goods.", Config.DEFAULT_PUNISH);
                return;
            }
            price = (long)((double)price * (1.0 + castleTaxRate + baseTaxRate));
            if ((subTotal += i.getCount() * price) > 99900000000L) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + 99900000000L + " adena worth of goods.", Config.DEFAULT_PUNISH);
                return;
            }
            weight += i.getCount() * (long)template.getWeight();
            if (!template.isStackable()) {
                slots += i.getCount();
                continue;
            }
            if (player.getInventory().getItemByItemId(i.getItemId()) != null) continue;
            ++slots;
        }
        if (!(player.isGM() || weight <= Integer.MAX_VALUE && weight >= 0L && player.getInventory().validateWeight((int)weight))) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!(player.isGM() || slots <= Integer.MAX_VALUE && slots >= 0L && player.getInventory().validateCapacity((int)slots))) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SLOTS_FULL));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (subTotal < 0L || !player.reduceAdena("Buy", subTotal, player.getLastFolkNPC(), false)) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        for (Item i : this._items) {
            L2TradeList.L2TradeItem tradeItem = list.getItemById(i.getItemId());
            if (tradeItem == null) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + i.getItemId(), Config.DEFAULT_PUNISH);
                continue;
            }
            if (tradeItem.hasLimitedStock()) {
                if (!tradeItem.decreaseCount(i.getCount())) continue;
                player.getInventory().addItem("Buy", i.getItemId(), i.getCount(), player, merchant);
                continue;
            }
            player.getInventory().addItem("Buy", i.getItemId(), i.getCount(), player, merchant);
        }
        if (merchant instanceof L2MerchantInstance) {
            ((L2MerchantInstance)merchant).getCastle().addToTreasury((long)((double)subTotal * castleTaxRate));
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.sendPacket(new ExBuySellListPacket(player, list, castleTaxRate + baseTaxRate, true));
    }

    @Override
    public String getType() {
        return _C__1F_REQUESTBUYITEM;
    }

    private static class Item {
        private final int _itemId;
        private final long _count;

        public Item(int id, long num) {
            this._itemId = id;
            this._count = num;
        }

        public int getItemId() {
            return this._itemId;
        }

        public long getCount() {
            return this._count;
        }
    }
}

