/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.form;

import com.l2jserver.gameserver.model.zone.L2ZoneForm;

public class ZoneNPoly
extends L2ZoneForm {
    private int[] _x;
    private int[] _y;
    private int _z1;
    private int _z2;

    public ZoneNPoly(int[] x, int[] y, int z1, int z2) {
        this._x = x;
        this._y = y;
        this._z1 = z1;
        this._z2 = z2;
    }

    @Override
    public boolean isInsideZone(int x, int y, int z) {
        if (z < this._z1 || z > this._z2) {
            return false;
        }
        boolean inside = false;
        int i = 0;
        int j = this._x.length - 1;
        while (i < this._x.length) {
            if ((this._y[i] <= y && y < this._y[j] || this._y[j] <= y && y < this._y[i]) && x < (this._x[j] - this._x[i]) * (y - this._y[i]) / (this._y[j] - this._y[i]) + this._x[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    @Override
    public boolean intersectsRectangle(int ax1, int ax2, int ay1, int ay2) {
        if (this._x[0] > ax1 && this._x[0] < ax2 && this._y[0] > ay1 && this._y[0] < ay2) {
            return true;
        }
        if (this.isInsideZone(ax1, ay1, this._z2 - 1)) {
            return true;
        }
        for (int i = 0; i < this._y.length; ++i) {
            int tX = this._x[i];
            int tY = this._y[i];
            int uX = this._x[(i + 1) % this._x.length];
            int uY = this._y[(i + 1) % this._x.length];
            if (this.lineSegmentsIntersect(tX, tY, uX, uY, ax1, ay1, ax1, ay2)) {
                return true;
            }
            if (this.lineSegmentsIntersect(tX, tY, uX, uY, ax1, ay1, ax2, ay1)) {
                return true;
            }
            if (this.lineSegmentsIntersect(tX, tY, uX, uY, ax2, ay2, ax1, ay2)) {
                return true;
            }
            if (!this.lineSegmentsIntersect(tX, tY, uX, uY, ax2, ay2, ax2, ay1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getDistanceToZone(int x, int y) {
        double shortestDist = Math.pow(this._x[0] - x, 2.0) + Math.pow(this._y[0] - y, 2.0);
        for (int i = 1; i < this._y.length; ++i) {
            double test = Math.pow(this._x[i] - x, 2.0) + Math.pow(this._y[i] - y, 2.0);
            if (!(test < shortestDist)) continue;
            shortestDist = test;
        }
        return Math.sqrt(shortestDist);
    }

    @Override
    public int getLowZ() {
        return this._z1;
    }

    @Override
    public int getHighZ() {
        return this._z2;
    }

    @Override
    public void visualizeZone(int z) {
        for (int i = 0; i < this._x.length; ++i) {
            int nextIndex = i + 1;
            if (nextIndex == this._x.length) {
                nextIndex = 0;
            }
            int vx = this._x[nextIndex] - this._x[i];
            int vy = this._y[nextIndex] - this._y[i];
            float lenght = (float)Math.sqrt(vx * vx + vy * vy);
            lenght /= 10.0f;
            int o = 1;
            while ((float)o <= lenght) {
                float k = (float)o / lenght;
                this.dropDebugItem(57, 1, (int)((float)this._x[i] + k * (float)vx), (int)((float)this._y[i] + k * (float)vy), z);
                ++o;
            }
        }
    }
}

