/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.stat.SummonStat;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Stats;

public class PetStat
extends SummonStat {
    public PetStat(L2PetInstance activeChar) {
        super(activeChar);
    }

    public boolean addExp(int value) {
        if (!super.addExp(value)) {
            return false;
        }
        this.getActiveChar().updateAndBroadcastStatus(1);
        this.getActiveChar().updateEffectIcons(true);
        return true;
    }

    @Override
    public boolean addExpAndSp(long addToExp, int addToSp) {
        if (!super.addExpAndSp(addToExp, addToSp)) {
            return false;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_EARNED_S1_EXP);
        sm.addExpNumber(addToExp);
        this.getActiveChar().updateAndBroadcastStatus(1);
        this.getActiveChar().getOwner().sendPacket(sm);
        return true;
    }

    @Override
    public final boolean addLevel(byte value) {
        if (this.getLevel() + value > this.getMaxLevel() - 1) {
            return false;
        }
        boolean levelIncreased = super.addLevel(value);
        if (levelIncreased) {
            this.getActiveChar().broadcastPacket(new SocialAction(this.getActiveChar(), 15));
        }
        StatusUpdate su = new StatusUpdate(this.getActiveChar());
        su.addAttribute(1, this.getLevel());
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(12, this.getMaxMp());
        this.getActiveChar().broadcastPacket(su);
        if (levelIncreased) {
            this.getActiveChar().broadcastPacket(new SocialAction(this.getActiveChar(), 2122));
        }
        this.getActiveChar().updateAndBroadcastStatus(1);
        if (this.getActiveChar().getControlItem() != null) {
            this.getActiveChar().getControlItem().setEnchantLevel(this.getLevel());
        }
        return levelIncreased;
    }

    @Override
    public final long getExpForLevel(int level) {
        try {
            return PetDataTable.getInstance().getPetLevelData(this.getActiveChar().getNpcId(), level).getPetMaxExp();
        }
        catch (NullPointerException e) {
            if (this.getActiveChar() != null) {
                _log.warning("Pet objectId:" + this.getActiveChar().getObjectId() + ", NpcId:" + this.getActiveChar().getNpcId() + ", level:" + level + " is missing data from pets_stats table!");
            }
            throw e;
        }
    }

    @Override
    public L2PetInstance getActiveChar() {
        return (L2PetInstance)super.getActiveChar();
    }

    public final int getFeedBattle() {
        return this.getActiveChar().getPetLevelData().getPetFeedBattle();
    }

    public final int getFeedNormal() {
        return this.getActiveChar().getPetLevelData().getPetFeedNormal();
    }

    @Override
    public void setLevel(byte value) {
        this.getActiveChar().setPetData(PetDataTable.getInstance().getPetLevelData(this.getActiveChar().getTemplate().npcId, value));
        if (this.getActiveChar().getPetLevelData() == null) {
            throw new IllegalArgumentException("No pet data for npc: " + this.getActiveChar().getTemplate().npcId + " level: " + value);
        }
        this.getActiveChar().stopFeed();
        super.setLevel(value);
        this.getActiveChar().startFeed();
        if (this.getActiveChar().getControlItem() != null) {
            this.getActiveChar().getControlItem().setEnchantLevel(this.getLevel());
        }
    }

    public final int getMaxFeed() {
        return this.getActiveChar().getPetLevelData().getPetMaxFeed();
    }

    @Override
    public int getMaxVisibleHp() {
        return (int)this.calcStat(Stats.MAX_HP, this.getActiveChar().getPetLevelData().getPetMaxHP(), null, null);
    }

    @Override
    public int getMaxMp() {
        return (int)this.calcStat(Stats.MAX_MP, this.getActiveChar().getPetLevelData().getPetMaxMP(), null, null);
    }

    @Override
    public int getMAtk(L2Character target, L2Skill skill) {
        Stats stat;
        double attack = this.getActiveChar().getPetLevelData().getPetMAtk();
        Stats stats = stat = skill == null ? null : skill.getStat();
        if (stat != null) {
            switch (stat) {
                case AGGRESSION: {
                    attack += (double)this.getActiveChar().getTemplate().baseAggression;
                    break;
                }
                case BLEED: {
                    attack += (double)this.getActiveChar().getTemplate().baseBleed;
                    break;
                }
                case POISON: {
                    attack += (double)this.getActiveChar().getTemplate().basePoison;
                    break;
                }
                case STUN: {
                    attack += (double)this.getActiveChar().getTemplate().baseStun;
                    break;
                }
                case ROOT: {
                    attack += (double)this.getActiveChar().getTemplate().baseRoot;
                    break;
                }
                case MOVEMENT: {
                    attack += (double)this.getActiveChar().getTemplate().baseMovement;
                    break;
                }
                case CONFUSION: {
                    attack += (double)this.getActiveChar().getTemplate().baseConfusion;
                    break;
                }
                case SLEEP: {
                    attack += (double)this.getActiveChar().getTemplate().baseSleep;
                }
            }
        }
        if (skill != null) {
            attack += skill.getPower();
        }
        return (int)this.calcStat(Stats.MAGIC_ATTACK, attack, target, skill);
    }

    @Override
    public int getMDef(L2Character target, L2Skill skill) {
        double defence = this.getActiveChar().getPetLevelData().getPetMDef();
        return (int)this.calcStat(Stats.MAGIC_DEFENCE, defence, target, skill);
    }

    @Override
    public int getPAtk(L2Character target) {
        return (int)this.calcStat(Stats.POWER_ATTACK, this.getActiveChar().getPetLevelData().getPetPAtk(), target, null);
    }

    @Override
    public int getPDef(L2Character target) {
        return (int)this.calcStat(Stats.POWER_DEFENCE, this.getActiveChar().getPetLevelData().getPetPDef(), target, null);
    }

    @Override
    public int getPAtkSpd() {
        int val = super.getPAtkSpd();
        if (this.getActiveChar().isHungry()) {
            val /= 2;
        }
        return val;
    }

    @Override
    public int getMAtkSpd() {
        int val = super.getMAtkSpd();
        if (this.getActiveChar().isHungry()) {
            val /= 2;
        }
        return val;
    }

    @Override
    public int getMaxLevel() {
        return 87;
    }
}

