/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExClosePartyRoom;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.Map;
import javolution.util.FastMap;

public class PartyMatchRoomList {
    private int _maxid = 1;
    private Map<Integer, PartyMatchRoom> _rooms = new FastMap();

    private PartyMatchRoomList() {
    }

    public synchronized void addPartyMatchRoom(int id, PartyMatchRoom room) {
        this._rooms.put(id, room);
        ++this._maxid;
    }

    public void deleteRoom(int id) {
        for (L2PcInstance _member : this.getRoom(id).getPartyMembers()) {
            if (_member == null) continue;
            _member.sendPacket(new ExClosePartyRoom());
            _member.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PARTY_ROOM_DISBANDED));
            _member.setPartyRoom(0);
            _member.broadcastUserInfo();
        }
        this._rooms.remove(id);
    }

    public PartyMatchRoom getRoom(int id) {
        return this._rooms.get(id);
    }

    public PartyMatchRoom[] getRooms() {
        return this._rooms.values().toArray(new PartyMatchRoom[this._rooms.size()]);
    }

    public int getPartyMatchRoomCount() {
        return this._rooms.size();
    }

    public int getMaxId() {
        return this._maxid;
    }

    public PartyMatchRoom getPlayerRoom(L2PcInstance player) {
        for (PartyMatchRoom _room : this._rooms.values()) {
            for (L2PcInstance member : _room.getPartyMembers()) {
                if (!member.equals(player)) continue;
                return _room;
            }
        }
        return null;
    }

    public int getPlayerRoomId(L2PcInstance player) {
        for (PartyMatchRoom _room : this._rooms.values()) {
            for (L2PcInstance member : _room.getPartyMembers()) {
                if (!member.equals(player)) continue;
                return _room.getId();
            }
        }
        return -1;
    }

    public static PartyMatchRoomList getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final PartyMatchRoomList _instance = new PartyMatchRoomList();

        private SingletonHolder() {
        }
    }
}

