/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager.favorite;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.communitybbs.Manager.favorite.BaseFavoriteManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.util.TextReplacer;
import com.l2jserver.util.Util;

public class RestartServer
extends BaseFavoriteManager {
    private static RestartServer _instance = new RestartServer();
    private static boolean _autorestart = false;
    private int _total;
    private int _score;
    private int _rate;

    public static RestartServer getInstance() {
        return _instance;
    }

    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        String arg = this.getArgs(command);
        if (arg.equals("_menu")) {
            this.showRestartServerMenu(activeChar);
        } else if (arg.equals("do")) {
            this.doRestartServer(activeChar);
        }
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
    }

    private void countRestartServer() {
        int total = 0;
        int score = 0;
        for (L2PcInstance pc : L2World.getInstance().getAllPlayers().values()) {
            L2GameClient c = pc.getClient();
            if (c == null || c.isDetached()) continue;
            ++total;
            if (!pc.voteServerRestart) continue;
            ++score;
        }
        this._total = total;
        this._score = score;
        this._rate = total == 0 ? 0 : score * 100 / total;
    }

    private void showRestartServerMenu(L2PcInstance activeChar) {
        TextReplacer html = new TextReplacer(HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/restart_srv/restartServer.htm"));
        String restartServer = _autorestart ? "<font color=\"LEVEL\">\u65e2\u306b\u518d\u8d77\u52d5\u304c\u53ef\u6c7a\u3055\u308c\u3066\u3044\u307e\u3059\u3002</font><br1><font color=\"LEVEL\">\u5b89\u5168\u306a\u5834\u6240\u3067\u30ed\u30b0\u30a2\u30a6\u30c8\u3057\u3066\u304f\u3060\u3055\u3044\u3002</font><br1>" : "<button value=\"\u7533\u8acb\u3059\u308b\" action=\"bypass _bbsgetfav;restart_srv;do\" width=80 height=21 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\"><br>\uff1c\u6ce8\u610f\u4e8b\u9805\uff1e<br1>\u30b5\u30fc\u30d0\u8d77\u52d5\u5f8c " + Util.strMillTime(Config.CUSTOM_SERVER_RESTART_INTERVAL) + " \u7d4c\u904e\u3057\u3066\u3044\u306a\u3044\u3068\u7533\u8acb\u3067\u304d\u307e\u305b\u3093\u3002<br1>" + "\u307e\u305f\u3001\u540c\u4e00\u30a2\u30ab\u30a6\u30f3\u30c8\u304b\u3089\u306e\u7533\u8acb\u306f\uff11\u56de\u306e\u307f\u3067\u3001\u30ed\u30b0\u30a2\u30a6\u30c8\u3057\u305f\u5834\u5408\u306f\u7121\u52b9\u3068\u306a\u308a\u307e\u3059\u3002<br1>";
        this.countRestartServer();
        html = html.replace((CharSequence)"%SERVER_RESTART_RATE%", Config.CUSTOM_SERVER_RESTART_RATE).replace((CharSequence)"%total%", this._total).replace((CharSequence)"%score%", this._score).replace((CharSequence)"%rate%", this._rate).replace((CharSequence)"%restartServer%", restartServer);
        this.separateAndSend(html.toString(), activeChar);
    }

    private void doRestartServer(L2PcInstance activeChar) {
        if (_autorestart) {
            this.showMessage(activeChar, "\u65e2\u306b\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u51e6\u7406\u306b\u79fb\u884c\u3057\u3066\u3044\u307e\u3059\u3002");
            return;
        }
        if (activeChar.voteServerRestart) {
            this.showMessage(activeChar, "\u65e2\u306b\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u7533\u8acb\u6e08\u3067\u3059\u3002");
            return;
        }
        if (activeChar.getLevel() < 10) {
            this.showMessage(activeChar, "\u30ec\u30d9\u30eb\uff11\uff10\u4ee5\u4e0a\u3067\u306a\u3051\u308c\u3070\u7533\u8acb\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        if (System.currentTimeMillis() < GameServer.gameServer.serverLoadEnd + Config.CUSTOM_SERVER_RESTART_INTERVAL) {
            this.showMessage(activeChar, "\u30b5\u30fc\u30d0\u8d77\u52d5\u5f8c\u3001\u898f\u5b9a\u6642\u9593\u304c\u7d4c\u904e\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            if (!castle.getSiege().getIsInProgress()) continue;
            this.showMessage(activeChar, "\u653b\u57ce\u6226\u4e2d\u306f\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u3092\u7533\u8acb\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        activeChar.voteServerRestart = true;
        this.countRestartServer();
        if (this._rate < Config.CUSTOM_SERVER_RESTART_RATE) {
            this.showMessage(activeChar, "\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u7533\u8acb\u3092\u53d7\u4ed8\u307e\u3057\u305f\u3002<br>\u5e0c\u671b\u8005\u6570\u304c\u7dcf\u30ed\u30b0\u30a4\u30f3\u6570\u306e " + Config.CUSTOM_SERVER_RESTART_RATE + "\uff05 \u306b\u9054\u3059\u308b\u307e\u3067\u30ed\u30b0\u30a2\u30a6\u30c8\u305b\u305a\u306b\u304a\u5f85\u3061\u4e0b\u3055\u3044\u3002");
            return;
        }
        if (this._score < Config.CUSTOM_SERVER_RESTART_MINIMUM) {
            this.showMessage(activeChar, "\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u7533\u8acb\u3092\u53d7\u4ed8\u307e\u3057\u305f\u3002<br>" + Config.CUSTOM_SERVER_RESTART_MINIMUM + " \u540d\u4ee5\u4e0a\u306e\u540c\u610f\u304c\u306a\u3051\u308c\u3070\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        _autorestart = true;
        this.showMessage(activeChar, "\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u304c\u53ef\u6c7a\u3055\u308c\u307e\u3057\u305f\u3002");
        Announcements.getInstance().announceToAll("\u3010\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u306e\u304a\u77e5\u3089\u305b\u3011");
        Announcements.getInstance().announceToAll("\u6295\u7968\u30b7\u30b9\u30c6\u30e0\u306b\u3088\u308a\u3001\u30b5\u30fc\u30d0\u30fc\u518d\u8d77\u52d5\u304c\u53ef\u6c7a\u3055\u308c\u307e\u3057\u305f\u3002");
        Announcements.getInstance().announceToAll("\u3053\u308c\u3088\u308a\u5f53\u30b5\u30fc\u30d0\u30fc\u306f\u518d\u8d77\u52d5\u51e6\u7406\u306b\u79fb\u884c\u3057\u307e\u3059\u3002");
        Announcements.getInstance().announceToAll("\u5b89\u5168\u306a\u5834\u6240\u3067\u30ed\u30b0\u30a2\u30a6\u30c8\u3059\u308b\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        Shutdown.getInstance().startShutdown(null, Config.CUSTOM_SERVER_RESTART_TIME, true);
    }
}

