/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2PlayableAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;

public class L2PlayerAI
extends L2PlayableAI {
    private boolean _thinking;
    L2CharacterAI.IntentionCommand _nextIntention = null;

    public L2PlayerAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    void saveNextIntention(CtrlIntention intention, Object arg0, Object arg1) {
        this._nextIntention = new L2CharacterAI.IntentionCommand(intention, arg0, arg1);
    }

    @Override
    public L2CharacterAI.IntentionCommand getNextIntention() {
        return this._nextIntention;
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention != CtrlIntention.AI_INTENTION_CAST || arg0 != null && ((L2Skill)arg0).isOffensive()) {
            this._nextIntention = null;
            super.changeIntention(intention, arg0, arg1);
            return;
        }
        if (intention == this._intention && arg0 == this._intentionArg0 && arg1 == this._intentionArg1) {
            super.changeIntention(intention, arg0, arg1);
            return;
        }
        this.saveNextIntention(this._intention, this._intentionArg0, this._intentionArg1);
        super.changeIntention(intention, arg0, arg1);
    }

    @Override
    protected void onEvtReadyToAct() {
        if (this._nextIntention != null) {
            this.setIntention(this._nextIntention._crtlIntention, this._nextIntention._arg0, this._nextIntention._arg1);
            this._nextIntention = null;
        }
        super.onEvtReadyToAct();
    }

    @Override
    protected void onEvtCancel() {
        this._nextIntention = null;
        super.onEvtCancel();
    }

    @Override
    protected void onEvtFinishCasting() {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
            L2CharacterAI.IntentionCommand nextIntention = this._nextIntention;
            if (nextIntention != null) {
                if (nextIntention._crtlIntention != CtrlIntention.AI_INTENTION_CAST) {
                    this.setIntention(nextIntention._crtlIntention, nextIntention._arg0, nextIntention._arg1);
                } else {
                    this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                }
            } else {
                this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
            }
        }
    }

    @Override
    protected void onIntentionRest() {
        if (this.getIntention() != CtrlIntention.AI_INTENTION_REST) {
            this.changeIntention(CtrlIntention.AI_INTENTION_REST, null, null);
            this.setTarget(null);
            if (this.getAttackTarget() != null) {
                this.setAttackTarget(null);
            }
            this.clientStopMoving(null);
        }
    }

    @Override
    protected void onIntentionActive() {
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    @Override
    protected void onIntentionMoveTo(L2CharPosition pos) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAttackingNow()) {
            this.clientActionFailed();
            this.saveNextIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos, null);
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos, null);
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveTo(pos.x, pos.y, pos.z);
    }

    @Override
    protected void clientNotifyDead() {
        this._clientMovingToPawnOffset = 0;
        this._clientMoving = false;
        super.clientNotifyDead();
    }

    private void thinkAttack() {
        L2Character target = this.getAttackTarget();
        if (target == null) {
            return;
        }
        if (this.checkTargetLostOrDead(target)) {
            this.setAttackTarget(null);
            return;
        }
        if (this.maybeMoveToPawn(target, this._actor.getPhysicalAttackRange())) {
            return;
        }
        this._accessor.doAttack(target);
    }

    private void thinkCast() {
        L2Object oldTarget;
        L2Character target = this.getCastTarget();
        if (Config.DEBUG) {
            _log.warning("L2PlayerAI: thinkCast -> Start");
        }
        if (this._skill.getTargetType() == L2Skill.SkillTargetType.TARGET_GROUND && this._actor instanceof L2PcInstance) {
            if (this.maybeMoveToPosition(((L2PcInstance)this._actor).getCurrentSkillWorldPosition(), this._actor.getMagicalAttackRange(this._skill))) {
                this._actor.setIsCastingNow(false);
                return;
            }
        } else {
            if (this.checkTargetLost(target)) {
                if (this._skill.isOffensive() && this.getAttackTarget() != null) {
                    this.setCastTarget(null);
                }
                this._actor.setIsCastingNow(false);
                return;
            }
            if (target != null && this.maybeMoveToPawn(target, this._actor.getMagicalAttackRange(this._skill))) {
                this._actor.setIsCastingNow(false);
                return;
            }
        }
        if (this._skill.getHitTime() > 50 && !this._skill.isSimultaneousCast()) {
            this.clientStopMoving(null);
        }
        if ((oldTarget = this._actor.getTarget()) != null && target != null && oldTarget != target) {
            this._actor.setTarget(this.getCastTarget());
            this._accessor.doCast(this._skill);
            this._actor.setTarget(oldTarget);
        } else {
            this._accessor.doCast(this._skill);
        }
    }

    private void thinkPickUp() {
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            return;
        }
        L2Object target = this.getTarget();
        if (this.checkTargetLost(target)) {
            return;
        }
        if (this.maybeMoveToPawn(target, 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        ((L2PcInstance.AIAccessor)this._accessor).doPickupItem(target);
    }

    private void thinkInteract() {
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            return;
        }
        L2Object target = this.getTarget();
        if (this.checkTargetLost(target)) {
            return;
        }
        if (this.maybeMoveToPawn(target, 36)) {
            return;
        }
        if (!(target instanceof L2StaticObjectInstance)) {
            ((L2PcInstance.AIAccessor)this._accessor).doInteract((L2Character)target);
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEvtThink() {
        if (this._thinking && this.getIntention() != CtrlIntention.AI_INTENTION_CAST) {
            return;
        }
        this._thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
                this.thinkCast();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.thinkPickUp();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT) {
                this.thinkInteract();
            }
        }
        finally {
            this._thinking = false;
        }
    }
}

